package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.{Version, Name}
import scala.jdk.CollectionConverters._
final case class ActivityType(name: Name, version: Version) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ActivityType = {
    import ActivityType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ActivityType
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .version(Version.unwrap(version): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.ActivityType.ReadOnly =
    zio.aws.swf.model.ActivityType.wrap(buildAwsValue())
}
object ActivityType {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.swf.model.ActivityType] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ActivityType =
      zio.aws.swf.model.ActivityType(name, version)
    def name: Name
    def version: Version
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getVersion: ZIO[Any, Nothing, Version] = ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ActivityType
  ) extends zio.aws.swf.model.ActivityType.ReadOnly {
    override val name: Name = zio.aws.swf.model.primitives.Name(impl.name())
    override val version: Version =
      zio.aws.swf.model.primitives.Version(impl.version())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ActivityType
  ): zio.aws.swf.model.ActivityType.ReadOnly = new Wrapper(impl)
}
