package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class GetWorkflowExecutionHistoryResponse(
    events: Iterable[zio.aws.swf.model.HistoryEvent],
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryResponse = {
    import GetWorkflowExecutionHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryResponse
      .builder()
      .events(events.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.GetWorkflowExecutionHistoryResponse.ReadOnly =
    zio.aws.swf.model.GetWorkflowExecutionHistoryResponse.wrap(buildAwsValue())
}
object GetWorkflowExecutionHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.GetWorkflowExecutionHistoryResponse =
      zio.aws.swf.model.GetWorkflowExecutionHistoryResponse(
        events.map { item =>
          item.asEditable
        },
        nextPageToken.map(value => value)
      )
    def events: List[zio.aws.swf.model.HistoryEvent.ReadOnly]
    def nextPageToken: Option[PageToken]
    def getEvents
        : ZIO[Any, Nothing, List[zio.aws.swf.model.HistoryEvent.ReadOnly]] =
      ZIO.succeed(events)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryResponse
  ) extends zio.aws.swf.model.GetWorkflowExecutionHistoryResponse.ReadOnly {
    override val events: List[zio.aws.swf.model.HistoryEvent.ReadOnly] = impl
      .events()
      .asScala
      .map { item =>
        zio.aws.swf.model.HistoryEvent.wrap(item)
      }
      .toList
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.swf.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryResponse
  ): zio.aws.swf.model.GetWorkflowExecutionHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
