package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{
  Data,
  WorkflowRunIdOptional,
  DomainName,
  TerminateReason,
  WorkflowId
}
import scala.jdk.CollectionConverters._
final case class TerminateWorkflowExecutionRequest(
    domain: DomainName,
    workflowId: WorkflowId,
    runId: Option[WorkflowRunIdOptional] = None,
    reason: Option[TerminateReason] = None,
    details: Option[Data] = None,
    childPolicy: Option[zio.aws.swf.model.ChildPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.TerminateWorkflowExecutionRequest = {
    import TerminateWorkflowExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.TerminateWorkflowExecutionRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .optionallyWith(
        runId.map(value =>
          WorkflowRunIdOptional.unwrap(value): java.lang.String
        )
      )(_.runId)
      .optionallyWith(
        reason.map(value => TerminateReason.unwrap(value): java.lang.String)
      )(_.reason)
      .optionallyWith(
        details.map(value => Data.unwrap(value): java.lang.String)
      )(_.details)
      .optionallyWith(childPolicy.map(value => value.unwrap))(_.childPolicy)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.TerminateWorkflowExecutionRequest.ReadOnly =
    zio.aws.swf.model.TerminateWorkflowExecutionRequest.wrap(buildAwsValue())
}
object TerminateWorkflowExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.TerminateWorkflowExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.TerminateWorkflowExecutionRequest =
      zio.aws.swf.model.TerminateWorkflowExecutionRequest(
        domain,
        workflowId,
        runId.map(value => value),
        reason.map(value => value),
        details.map(value => value),
        childPolicy.map(value => value)
      )
    def domain: DomainName
    def workflowId: WorkflowId
    def runId: Option[WorkflowRunIdOptional]
    def reason: Option[TerminateReason]
    def details: Option[Data]
    def childPolicy: Option[zio.aws.swf.model.ChildPolicy]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getRunId: ZIO[Any, AwsError, WorkflowRunIdOptional] =
      AwsError.unwrapOptionField("runId", runId)
    def getReason: ZIO[Any, AwsError, TerminateReason] =
      AwsError.unwrapOptionField("reason", reason)
    def getDetails: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("details", details)
    def getChildPolicy: ZIO[Any, AwsError, zio.aws.swf.model.ChildPolicy] =
      AwsError.unwrapOptionField("childPolicy", childPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.TerminateWorkflowExecutionRequest
  ) extends zio.aws.swf.model.TerminateWorkflowExecutionRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val workflowId: WorkflowId =
      zio.aws.swf.model.primitives.WorkflowId(impl.workflowId())
    override val runId: Option[WorkflowRunIdOptional] = scala
      .Option(impl.runId())
      .map(value => zio.aws.swf.model.primitives.WorkflowRunIdOptional(value))
    override val reason: Option[TerminateReason] = scala
      .Option(impl.reason())
      .map(value => zio.aws.swf.model.primitives.TerminateReason(value))
    override val details: Option[Data] = scala
      .Option(impl.details())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val childPolicy: Option[zio.aws.swf.model.ChildPolicy] = scala
      .Option(impl.childPolicy())
      .map(value => zio.aws.swf.model.ChildPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.TerminateWorkflowExecutionRequest
  ): zio.aws.swf.model.TerminateWorkflowExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
