package zio.aws.swf.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{
  ReverseOrder,
  DomainName,
  PageToken,
  PageSize,
  Name
}
import scala.jdk.CollectionConverters._
final case class ListActivityTypesRequest(
    domain: DomainName,
    name: Option[Name] = None,
    registrationStatus: zio.aws.swf.model.RegistrationStatus,
    nextPageToken: Option[PageToken] = None,
    maximumPageSize: Option[PageSize] = None,
    reverseOrder: Option[ReverseOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ListActivityTypesRequest = {
    import ListActivityTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ListActivityTypesRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .registrationStatus(registrationStatus.unwrap)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .optionallyWith(
        maximumPageSize.map(value => PageSize.unwrap(value): Integer)
      )(_.maximumPageSize)
      .optionallyWith(
        reverseOrder.map(value => ReverseOrder.unwrap(value): java.lang.Boolean)
      )(_.reverseOrder)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.ListActivityTypesRequest.ReadOnly =
    zio.aws.swf.model.ListActivityTypesRequest.wrap(buildAwsValue())
}
object ListActivityTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ListActivityTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ListActivityTypesRequest =
      zio.aws.swf.model.ListActivityTypesRequest(
        domain,
        name.map(value => value),
        registrationStatus,
        nextPageToken.map(value => value),
        maximumPageSize.map(value => value),
        reverseOrder.map(value => value)
      )
    def domain: DomainName
    def name: Option[Name]
    def registrationStatus: zio.aws.swf.model.RegistrationStatus
    def nextPageToken: Option[PageToken]
    def maximumPageSize: Option[PageSize]
    def reverseOrder: Option[ReverseOrder]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getRegistrationStatus
        : ZIO[Any, Nothing, zio.aws.swf.model.RegistrationStatus] =
      ZIO.succeed(registrationStatus)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
    def getMaximumPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maximumPageSize", maximumPageSize)
    def getReverseOrder: ZIO[Any, AwsError, ReverseOrder] =
      AwsError.unwrapOptionField("reverseOrder", reverseOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ListActivityTypesRequest
  ) extends zio.aws.swf.model.ListActivityTypesRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.swf.model.primitives.Name(value))
    override val registrationStatus: zio.aws.swf.model.RegistrationStatus =
      zio.aws.swf.model.RegistrationStatus.wrap(impl.registrationStatus())
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.swf.model.primitives.PageToken(value))
    override val maximumPageSize: Option[PageSize] = scala
      .Option(impl.maximumPageSize())
      .map(value => zio.aws.swf.model.primitives.PageSize(value))
    override val reverseOrder: Option[ReverseOrder] = scala
      .Option(impl.reverseOrder())
      .map(value => zio.aws.swf.model.primitives.ReverseOrder(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ListActivityTypesRequest
  ): zio.aws.swf.model.ListActivityTypesRequest.ReadOnly = new Wrapper(impl)
}
