package zio.aws.swf.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{Truncated, Count}
import scala.jdk.CollectionConverters._
final case class CountOpenWorkflowExecutionsResponse(
    count: Count,
    truncated: Option[Truncated] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsResponse = {
    import CountOpenWorkflowExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsResponse
      .builder()
      .count(Count.unwrap(count): Integer)
      .optionallyWith(
        truncated.map(value => Truncated.unwrap(value): java.lang.Boolean)
      )(_.truncated)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.CountOpenWorkflowExecutionsResponse.ReadOnly =
    zio.aws.swf.model.CountOpenWorkflowExecutionsResponse.wrap(buildAwsValue())
}
object CountOpenWorkflowExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.CountOpenWorkflowExecutionsResponse =
      zio.aws.swf.model.CountOpenWorkflowExecutionsResponse(
        count,
        truncated.map(value => value)
      )
    def count: Count
    def truncated: Option[Truncated]
    def getCount: ZIO[Any, Nothing, Count] = ZIO.succeed(count)
    def getTruncated: ZIO[Any, AwsError, Truncated] =
      AwsError.unwrapOptionField("truncated", truncated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsResponse
  ) extends zio.aws.swf.model.CountOpenWorkflowExecutionsResponse.ReadOnly {
    override val count: Count = zio.aws.swf.model.primitives.Count(impl.count())
    override val truncated: Option[Truncated] = scala
      .Option(impl.truncated())
      .map(value => zio.aws.swf.model.primitives.Truncated(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsResponse
  ): zio.aws.swf.model.CountOpenWorkflowExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
