package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{Arn, TaskPriority, DurationInSeconds}
import scala.jdk.CollectionConverters._
final case class WorkflowExecutionConfiguration(
    taskStartToCloseTimeout: DurationInSeconds,
    executionStartToCloseTimeout: DurationInSeconds,
    taskList: zio.aws.swf.model.TaskList,
    taskPriority: Option[TaskPriority] = None,
    childPolicy: zio.aws.swf.model.ChildPolicy,
    lambdaRole: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowExecutionConfiguration = {
    import WorkflowExecutionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowExecutionConfiguration
      .builder()
      .taskStartToCloseTimeout(
        DurationInSeconds.unwrap(taskStartToCloseTimeout): java.lang.String
      )
      .executionStartToCloseTimeout(
        DurationInSeconds.unwrap(executionStartToCloseTimeout): java.lang.String
      )
      .taskList(taskList.buildAwsValue())
      .optionallyWith(
        taskPriority.map(value => TaskPriority.unwrap(value): java.lang.String)
      )(_.taskPriority)
      .childPolicy(childPolicy.unwrap)
      .optionallyWith(
        lambdaRole.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lambdaRole)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.WorkflowExecutionConfiguration.ReadOnly =
    zio.aws.swf.model.WorkflowExecutionConfiguration.wrap(buildAwsValue())
}
object WorkflowExecutionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowExecutionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.WorkflowExecutionConfiguration =
      zio.aws.swf.model.WorkflowExecutionConfiguration(
        taskStartToCloseTimeout,
        executionStartToCloseTimeout,
        taskList.asEditable,
        taskPriority.map(value => value),
        childPolicy,
        lambdaRole.map(value => value)
      )
    def taskStartToCloseTimeout: DurationInSeconds
    def executionStartToCloseTimeout: DurationInSeconds
    def taskList: zio.aws.swf.model.TaskList.ReadOnly
    def taskPriority: Option[TaskPriority]
    def childPolicy: zio.aws.swf.model.ChildPolicy
    def lambdaRole: Option[Arn]
    def getTaskStartToCloseTimeout: ZIO[Any, Nothing, DurationInSeconds] =
      ZIO.succeed(taskStartToCloseTimeout)
    def getExecutionStartToCloseTimeout: ZIO[Any, Nothing, DurationInSeconds] =
      ZIO.succeed(executionStartToCloseTimeout)
    def getTaskList: ZIO[Any, Nothing, zio.aws.swf.model.TaskList.ReadOnly] =
      ZIO.succeed(taskList)
    def getTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("taskPriority", taskPriority)
    def getChildPolicy: ZIO[Any, Nothing, zio.aws.swf.model.ChildPolicy] =
      ZIO.succeed(childPolicy)
    def getLambdaRole: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lambdaRole", lambdaRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionConfiguration
  ) extends zio.aws.swf.model.WorkflowExecutionConfiguration.ReadOnly {
    override val taskStartToCloseTimeout: DurationInSeconds =
      zio.aws.swf.model.primitives
        .DurationInSeconds(impl.taskStartToCloseTimeout())
    override val executionStartToCloseTimeout: DurationInSeconds =
      zio.aws.swf.model.primitives
        .DurationInSeconds(impl.executionStartToCloseTimeout())
    override val taskList: zio.aws.swf.model.TaskList.ReadOnly =
      zio.aws.swf.model.TaskList.wrap(impl.taskList())
    override val taskPriority: Option[TaskPriority] = scala
      .Option(impl.taskPriority())
      .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val childPolicy: zio.aws.swf.model.ChildPolicy =
      zio.aws.swf.model.ChildPolicy.wrap(impl.childPolicy())
    override val lambdaRole: Option[Arn] = scala
      .Option(impl.lambdaRole())
      .map(value => zio.aws.swf.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionConfiguration
  ): zio.aws.swf.model.WorkflowExecutionConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
