package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{Data, EventId, ActivityId, TaskToken}
import scala.jdk.CollectionConverters._
final case class PollForActivityTaskResponse(
    taskToken: TaskToken,
    activityId: ActivityId,
    startedEventId: EventId,
    workflowExecution: zio.aws.swf.model.WorkflowExecution,
    activityType: zio.aws.swf.model.ActivityType,
    input: Option[Data] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.PollForActivityTaskResponse = {
    import PollForActivityTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.PollForActivityTaskResponse
      .builder()
      .taskToken(TaskToken.unwrap(taskToken): java.lang.String)
      .activityId(ActivityId.unwrap(activityId): java.lang.String)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .workflowExecution(workflowExecution.buildAwsValue())
      .activityType(activityType.buildAwsValue())
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .build()
  }
  def asReadOnly: zio.aws.swf.model.PollForActivityTaskResponse.ReadOnly =
    zio.aws.swf.model.PollForActivityTaskResponse.wrap(buildAwsValue())
}
object PollForActivityTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.PollForActivityTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.PollForActivityTaskResponse =
      zio.aws.swf.model.PollForActivityTaskResponse(
        taskToken,
        activityId,
        startedEventId,
        workflowExecution.asEditable,
        activityType.asEditable,
        input.map(value => value)
      )
    def taskToken: TaskToken
    def activityId: ActivityId
    def startedEventId: EventId
    def workflowExecution: zio.aws.swf.model.WorkflowExecution.ReadOnly
    def activityType: zio.aws.swf.model.ActivityType.ReadOnly
    def input: Option[Data]
    def getTaskToken: ZIO[Any, Nothing, TaskToken] = ZIO.succeed(taskToken)
    def getActivityId: ZIO[Any, Nothing, ActivityId] = ZIO.succeed(activityId)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
    def getWorkflowExecution
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      ZIO.succeed(workflowExecution)
    def getActivityType
        : ZIO[Any, Nothing, zio.aws.swf.model.ActivityType.ReadOnly] =
      ZIO.succeed(activityType)
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.PollForActivityTaskResponse
  ) extends zio.aws.swf.model.PollForActivityTaskResponse.ReadOnly {
    override val taskToken: TaskToken =
      zio.aws.swf.model.primitives.TaskToken(impl.taskToken())
    override val activityId: ActivityId =
      zio.aws.swf.model.primitives.ActivityId(impl.activityId())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
    override val workflowExecution
        : zio.aws.swf.model.WorkflowExecution.ReadOnly =
      zio.aws.swf.model.WorkflowExecution.wrap(impl.workflowExecution())
    override val activityType: zio.aws.swf.model.ActivityType.ReadOnly =
      zio.aws.swf.model.ActivityType.wrap(impl.activityType())
    override val input: Option[Data] = scala
      .Option(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.PollForActivityTaskResponse
  ): zio.aws.swf.model.PollForActivityTaskResponse.ReadOnly = new Wrapper(impl)
}
