package zio.aws.swf.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{ReverseOrder, PageSize, PageToken}
import scala.jdk.CollectionConverters._
final case class ListDomainsRequest(
    nextPageToken: Option[PageToken] = None,
    registrationStatus: zio.aws.swf.model.RegistrationStatus,
    maximumPageSize: Option[PageSize] = None,
    reverseOrder: Option[ReverseOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ListDomainsRequest = {
    import ListDomainsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ListDomainsRequest
      .builder()
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .registrationStatus(registrationStatus.unwrap)
      .optionallyWith(
        maximumPageSize.map(value => PageSize.unwrap(value): Integer)
      )(_.maximumPageSize)
      .optionallyWith(
        reverseOrder.map(value => ReverseOrder.unwrap(value): java.lang.Boolean)
      )(_.reverseOrder)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.ListDomainsRequest.ReadOnly =
    zio.aws.swf.model.ListDomainsRequest.wrap(buildAwsValue())
}
object ListDomainsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ListDomainsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ListDomainsRequest =
      zio.aws.swf.model.ListDomainsRequest(
        nextPageToken.map(value => value),
        registrationStatus,
        maximumPageSize.map(value => value),
        reverseOrder.map(value => value)
      )
    def nextPageToken: Option[PageToken]
    def registrationStatus: zio.aws.swf.model.RegistrationStatus
    def maximumPageSize: Option[PageSize]
    def reverseOrder: Option[ReverseOrder]
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
    def getRegistrationStatus
        : ZIO[Any, Nothing, zio.aws.swf.model.RegistrationStatus] =
      ZIO.succeed(registrationStatus)
    def getMaximumPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maximumPageSize", maximumPageSize)
    def getReverseOrder: ZIO[Any, AwsError, ReverseOrder] =
      AwsError.unwrapOptionField("reverseOrder", reverseOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ListDomainsRequest
  ) extends zio.aws.swf.model.ListDomainsRequest.ReadOnly {
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.swf.model.primitives.PageToken(value))
    override val registrationStatus: zio.aws.swf.model.RegistrationStatus =
      zio.aws.swf.model.RegistrationStatus.wrap(impl.registrationStatus())
    override val maximumPageSize: Option[PageSize] = scala
      .Option(impl.maximumPageSize())
      .map(value => zio.aws.swf.model.primitives.PageSize(value))
    override val reverseOrder: Option[ReverseOrder] = scala
      .Option(impl.reverseOrder())
      .map(value => zio.aws.swf.model.primitives.ReverseOrder(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ListDomainsRequest
  ): zio.aws.swf.model.ListDomainsRequest.ReadOnly = new Wrapper(impl)
}
