package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{Data, EventId}
import scala.jdk.CollectionConverters._
final case class LambdaFunctionCompletedEventAttributes(
    scheduledEventId: EventId,
    startedEventId: EventId,
    result: Option[Data] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.LambdaFunctionCompletedEventAttributes = {
    import LambdaFunctionCompletedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.LambdaFunctionCompletedEventAttributes
      .builder()
      .scheduledEventId(EventId.unwrap(scheduledEventId): java.lang.Long)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .optionallyWith(
        result.map(value => Data.unwrap(value): java.lang.String)
      )(_.result)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.LambdaFunctionCompletedEventAttributes.ReadOnly =
    zio.aws.swf.model.LambdaFunctionCompletedEventAttributes
      .wrap(buildAwsValue())
}
object LambdaFunctionCompletedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.LambdaFunctionCompletedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.LambdaFunctionCompletedEventAttributes =
      zio.aws.swf.model.LambdaFunctionCompletedEventAttributes(
        scheduledEventId,
        startedEventId,
        result.map(value => value)
      )
    def scheduledEventId: EventId
    def startedEventId: EventId
    def result: Option[Data]
    def getScheduledEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(scheduledEventId)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
    def getResult: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("result", result)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.LambdaFunctionCompletedEventAttributes
  ) extends zio.aws.swf.model.LambdaFunctionCompletedEventAttributes.ReadOnly {
    override val scheduledEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.scheduledEventId())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
    override val result: Option[Data] = scala
      .Option(impl.result())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.LambdaFunctionCompletedEventAttributes
  ): zio.aws.swf.model.LambdaFunctionCompletedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
