package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Decision(
    decisionType: zio.aws.swf.model.DecisionType,
    scheduleActivityTaskDecisionAttributes: Option[
      zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes
    ] = None,
    requestCancelActivityTaskDecisionAttributes: Option[
      zio.aws.swf.model.RequestCancelActivityTaskDecisionAttributes
    ] = None,
    completeWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.CompleteWorkflowExecutionDecisionAttributes
    ] = None,
    failWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.FailWorkflowExecutionDecisionAttributes
    ] = None,
    cancelWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.CancelWorkflowExecutionDecisionAttributes
    ] = None,
    continueAsNewWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes
    ] = None,
    recordMarkerDecisionAttributes: Option[
      zio.aws.swf.model.RecordMarkerDecisionAttributes
    ] = None,
    startTimerDecisionAttributes: Option[
      zio.aws.swf.model.StartTimerDecisionAttributes
    ] = None,
    cancelTimerDecisionAttributes: Option[
      zio.aws.swf.model.CancelTimerDecisionAttributes
    ] = None,
    signalExternalWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.SignalExternalWorkflowExecutionDecisionAttributes
    ] = None,
    requestCancelExternalWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes
    ] = None,
    startChildWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.StartChildWorkflowExecutionDecisionAttributes
    ] = None,
    scheduleLambdaFunctionDecisionAttributes: Option[
      zio.aws.swf.model.ScheduleLambdaFunctionDecisionAttributes
    ] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.swf.model.Decision = {
    import Decision.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.Decision
      .builder()
      .decisionType(decisionType.unwrap)
      .optionallyWith(
        scheduleActivityTaskDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.scheduleActivityTaskDecisionAttributes)
      .optionallyWith(
        requestCancelActivityTaskDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.requestCancelActivityTaskDecisionAttributes)
      .optionallyWith(
        completeWorkflowExecutionDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.completeWorkflowExecutionDecisionAttributes)
      .optionallyWith(
        failWorkflowExecutionDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.failWorkflowExecutionDecisionAttributes)
      .optionallyWith(
        cancelWorkflowExecutionDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.cancelWorkflowExecutionDecisionAttributes)
      .optionallyWith(
        continueAsNewWorkflowExecutionDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.continueAsNewWorkflowExecutionDecisionAttributes)
      .optionallyWith(
        recordMarkerDecisionAttributes.map(value => value.buildAwsValue())
      )(_.recordMarkerDecisionAttributes)
      .optionallyWith(
        startTimerDecisionAttributes.map(value => value.buildAwsValue())
      )(_.startTimerDecisionAttributes)
      .optionallyWith(
        cancelTimerDecisionAttributes.map(value => value.buildAwsValue())
      )(_.cancelTimerDecisionAttributes)
      .optionallyWith(
        signalExternalWorkflowExecutionDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.signalExternalWorkflowExecutionDecisionAttributes)
      .optionallyWith(
        requestCancelExternalWorkflowExecutionDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.requestCancelExternalWorkflowExecutionDecisionAttributes)
      .optionallyWith(
        startChildWorkflowExecutionDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.startChildWorkflowExecutionDecisionAttributes)
      .optionallyWith(
        scheduleLambdaFunctionDecisionAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.scheduleLambdaFunctionDecisionAttributes)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.Decision.ReadOnly =
    zio.aws.swf.model.Decision.wrap(buildAwsValue())
}
object Decision {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.swf.model.Decision] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.Decision = zio.aws.swf.model.Decision(
      decisionType,
      scheduleActivityTaskDecisionAttributes.map(value => value.asEditable),
      requestCancelActivityTaskDecisionAttributes.map(value =>
        value.asEditable
      ),
      completeWorkflowExecutionDecisionAttributes.map(value =>
        value.asEditable
      ),
      failWorkflowExecutionDecisionAttributes.map(value => value.asEditable),
      cancelWorkflowExecutionDecisionAttributes.map(value => value.asEditable),
      continueAsNewWorkflowExecutionDecisionAttributes.map(value =>
        value.asEditable
      ),
      recordMarkerDecisionAttributes.map(value => value.asEditable),
      startTimerDecisionAttributes.map(value => value.asEditable),
      cancelTimerDecisionAttributes.map(value => value.asEditable),
      signalExternalWorkflowExecutionDecisionAttributes.map(value =>
        value.asEditable
      ),
      requestCancelExternalWorkflowExecutionDecisionAttributes.map(value =>
        value.asEditable
      ),
      startChildWorkflowExecutionDecisionAttributes.map(value =>
        value.asEditable
      ),
      scheduleLambdaFunctionDecisionAttributes.map(value => value.asEditable)
    )
    def decisionType: zio.aws.swf.model.DecisionType
    def scheduleActivityTaskDecisionAttributes: Option[
      zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes.ReadOnly
    ]
    def requestCancelActivityTaskDecisionAttributes: Option[
      zio.aws.swf.model.RequestCancelActivityTaskDecisionAttributes.ReadOnly
    ]
    def completeWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.CompleteWorkflowExecutionDecisionAttributes.ReadOnly
    ]
    def failWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.FailWorkflowExecutionDecisionAttributes.ReadOnly
    ]
    def cancelWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.CancelWorkflowExecutionDecisionAttributes.ReadOnly
    ]
    def continueAsNewWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes.ReadOnly
    ]
    def recordMarkerDecisionAttributes
        : Option[zio.aws.swf.model.RecordMarkerDecisionAttributes.ReadOnly]
    def startTimerDecisionAttributes
        : Option[zio.aws.swf.model.StartTimerDecisionAttributes.ReadOnly]
    def cancelTimerDecisionAttributes
        : Option[zio.aws.swf.model.CancelTimerDecisionAttributes.ReadOnly]
    def signalExternalWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.SignalExternalWorkflowExecutionDecisionAttributes.ReadOnly
    ]
    def requestCancelExternalWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes.ReadOnly
    ]
    def startChildWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.StartChildWorkflowExecutionDecisionAttributes.ReadOnly
    ]
    def scheduleLambdaFunctionDecisionAttributes: Option[
      zio.aws.swf.model.ScheduleLambdaFunctionDecisionAttributes.ReadOnly
    ]
    def getDecisionType: ZIO[Any, Nothing, zio.aws.swf.model.DecisionType] =
      ZIO.succeed(decisionType)
    def getScheduleActivityTaskDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scheduleActivityTaskDecisionAttributes",
      scheduleActivityTaskDecisionAttributes
    )
    def getRequestCancelActivityTaskDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.RequestCancelActivityTaskDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "requestCancelActivityTaskDecisionAttributes",
      requestCancelActivityTaskDecisionAttributes
    )
    def getCompleteWorkflowExecutionDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.CompleteWorkflowExecutionDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "completeWorkflowExecutionDecisionAttributes",
      completeWorkflowExecutionDecisionAttributes
    )
    def getFailWorkflowExecutionDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.FailWorkflowExecutionDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "failWorkflowExecutionDecisionAttributes",
      failWorkflowExecutionDecisionAttributes
    )
    def getCancelWorkflowExecutionDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.CancelWorkflowExecutionDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cancelWorkflowExecutionDecisionAttributes",
      cancelWorkflowExecutionDecisionAttributes
    )
    def getContinueAsNewWorkflowExecutionDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "continueAsNewWorkflowExecutionDecisionAttributes",
      continueAsNewWorkflowExecutionDecisionAttributes
    )
    def getRecordMarkerDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.RecordMarkerDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "recordMarkerDecisionAttributes",
      recordMarkerDecisionAttributes
    )
    def getStartTimerDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.StartTimerDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "startTimerDecisionAttributes",
      startTimerDecisionAttributes
    )
    def getCancelTimerDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.CancelTimerDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cancelTimerDecisionAttributes",
      cancelTimerDecisionAttributes
    )
    def getSignalExternalWorkflowExecutionDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.SignalExternalWorkflowExecutionDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "signalExternalWorkflowExecutionDecisionAttributes",
      signalExternalWorkflowExecutionDecisionAttributes
    )
    def getRequestCancelExternalWorkflowExecutionDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "requestCancelExternalWorkflowExecutionDecisionAttributes",
      requestCancelExternalWorkflowExecutionDecisionAttributes
    )
    def getStartChildWorkflowExecutionDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.StartChildWorkflowExecutionDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "startChildWorkflowExecutionDecisionAttributes",
      startChildWorkflowExecutionDecisionAttributes
    )
    def getScheduleLambdaFunctionDecisionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ScheduleLambdaFunctionDecisionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scheduleLambdaFunctionDecisionAttributes",
      scheduleLambdaFunctionDecisionAttributes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.Decision
  ) extends zio.aws.swf.model.Decision.ReadOnly {
    override val decisionType: zio.aws.swf.model.DecisionType =
      zio.aws.swf.model.DecisionType.wrap(impl.decisionType())
    override val scheduleActivityTaskDecisionAttributes: Option[
      zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes.ReadOnly
    ] = scala
      .Option(impl.scheduleActivityTaskDecisionAttributes())
      .map(value =>
        zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes.wrap(value)
      )
    override val requestCancelActivityTaskDecisionAttributes: Option[
      zio.aws.swf.model.RequestCancelActivityTaskDecisionAttributes.ReadOnly
    ] = scala
      .Option(impl.requestCancelActivityTaskDecisionAttributes())
      .map(value =>
        zio.aws.swf.model.RequestCancelActivityTaskDecisionAttributes
          .wrap(value)
      )
    override val completeWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.CompleteWorkflowExecutionDecisionAttributes.ReadOnly
    ] = scala
      .Option(impl.completeWorkflowExecutionDecisionAttributes())
      .map(value =>
        zio.aws.swf.model.CompleteWorkflowExecutionDecisionAttributes
          .wrap(value)
      )
    override val failWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.FailWorkflowExecutionDecisionAttributes.ReadOnly
    ] = scala
      .Option(impl.failWorkflowExecutionDecisionAttributes())
      .map(value =>
        zio.aws.swf.model.FailWorkflowExecutionDecisionAttributes.wrap(value)
      )
    override val cancelWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.CancelWorkflowExecutionDecisionAttributes.ReadOnly
    ] = scala
      .Option(impl.cancelWorkflowExecutionDecisionAttributes())
      .map(value =>
        zio.aws.swf.model.CancelWorkflowExecutionDecisionAttributes.wrap(value)
      )
    override val continueAsNewWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes.ReadOnly
    ] = scala
      .Option(impl.continueAsNewWorkflowExecutionDecisionAttributes())
      .map(value =>
        zio.aws.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes
          .wrap(value)
      )
    override val recordMarkerDecisionAttributes
        : Option[zio.aws.swf.model.RecordMarkerDecisionAttributes.ReadOnly] =
      scala
        .Option(impl.recordMarkerDecisionAttributes())
        .map(value =>
          zio.aws.swf.model.RecordMarkerDecisionAttributes.wrap(value)
        )
    override val startTimerDecisionAttributes
        : Option[zio.aws.swf.model.StartTimerDecisionAttributes.ReadOnly] =
      scala
        .Option(impl.startTimerDecisionAttributes())
        .map(value =>
          zio.aws.swf.model.StartTimerDecisionAttributes.wrap(value)
        )
    override val cancelTimerDecisionAttributes
        : Option[zio.aws.swf.model.CancelTimerDecisionAttributes.ReadOnly] =
      scala
        .Option(impl.cancelTimerDecisionAttributes())
        .map(value =>
          zio.aws.swf.model.CancelTimerDecisionAttributes.wrap(value)
        )
    override val signalExternalWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.SignalExternalWorkflowExecutionDecisionAttributes.ReadOnly
    ] = scala
      .Option(impl.signalExternalWorkflowExecutionDecisionAttributes())
      .map(value =>
        zio.aws.swf.model.SignalExternalWorkflowExecutionDecisionAttributes
          .wrap(value)
      )
    override val requestCancelExternalWorkflowExecutionDecisionAttributes
        : Option[
          zio.aws.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes.ReadOnly
        ] = scala
      .Option(impl.requestCancelExternalWorkflowExecutionDecisionAttributes())
      .map(value =>
        zio.aws.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes
          .wrap(value)
      )
    override val startChildWorkflowExecutionDecisionAttributes: Option[
      zio.aws.swf.model.StartChildWorkflowExecutionDecisionAttributes.ReadOnly
    ] = scala
      .Option(impl.startChildWorkflowExecutionDecisionAttributes())
      .map(value =>
        zio.aws.swf.model.StartChildWorkflowExecutionDecisionAttributes
          .wrap(value)
      )
    override val scheduleLambdaFunctionDecisionAttributes: Option[
      zio.aws.swf.model.ScheduleLambdaFunctionDecisionAttributes.ReadOnly
    ] = scala
      .Option(impl.scheduleLambdaFunctionDecisionAttributes())
      .map(value =>
        zio.aws.swf.model.ScheduleLambdaFunctionDecisionAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.Decision
  ): zio.aws.swf.model.Decision.ReadOnly = new Wrapper(impl)
}
