package zio.aws.swf.model
import scala.jdk.CollectionConverters._
sealed trait ActivityTaskTimeoutType {
  def unwrap: software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType
}
object ActivityTaskTimeoutType {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType
  ): zio.aws.swf.model.ActivityTaskTimeoutType = value match {
    case software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType.START_TO_CLOSE =>
      val r = START_TO_CLOSE
      r
    case software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType.SCHEDULE_TO_START =>
      val r = SCHEDULE_TO_START
      r
    case software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType.SCHEDULE_TO_CLOSE =>
      val r = SCHEDULE_TO_CLOSE
      r
    case software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType.HEARTBEAT =>
      val r = HEARTBEAT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.swf.model.ActivityTaskTimeoutType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType =
      software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType.UNKNOWN_TO_SDK_VERSION
  }
  case object START_TO_CLOSE extends zio.aws.swf.model.ActivityTaskTimeoutType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType =
      software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType.START_TO_CLOSE
  }
  case object SCHEDULE_TO_START
      extends zio.aws.swf.model.ActivityTaskTimeoutType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType =
      software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType.SCHEDULE_TO_START
  }
  case object SCHEDULE_TO_CLOSE
      extends zio.aws.swf.model.ActivityTaskTimeoutType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType =
      software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType.SCHEDULE_TO_CLOSE
  }
  case object HEARTBEAT extends zio.aws.swf.model.ActivityTaskTimeoutType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType =
      software.amazon.awssdk.services.swf.model.ActivityTaskTimeoutType.HEARTBEAT
  }
}
