package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.swf.model.primitives.{Timestamp, Description}
import scala.jdk.CollectionConverters._
final case class ActivityTypeInfo(
    activityType: zio.aws.swf.model.ActivityType,
    status: zio.aws.swf.model.RegistrationStatus,
    description: Option[Description] = None,
    creationDate: Timestamp,
    deprecationDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ActivityTypeInfo = {
    import ActivityTypeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ActivityTypeInfo
      .builder()
      .activityType(activityType.buildAwsValue())
      .status(status.unwrap)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .optionallyWith(
        deprecationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.deprecationDate)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.ActivityTypeInfo.ReadOnly =
    zio.aws.swf.model.ActivityTypeInfo.wrap(buildAwsValue())
}
object ActivityTypeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ActivityTypeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ActivityTypeInfo =
      zio.aws.swf.model.ActivityTypeInfo(
        activityType.asEditable,
        status,
        description.map(value => value),
        creationDate,
        deprecationDate.map(value => value)
      )
    def activityType: zio.aws.swf.model.ActivityType.ReadOnly
    def status: zio.aws.swf.model.RegistrationStatus
    def description: Option[Description]
    def creationDate: Timestamp
    def deprecationDate: Option[Timestamp]
    def getActivityType
        : ZIO[Any, Nothing, zio.aws.swf.model.ActivityType.ReadOnly] =
      ZIO.succeed(activityType)
    def getStatus: ZIO[Any, Nothing, zio.aws.swf.model.RegistrationStatus] =
      ZIO.succeed(status)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
    def getDeprecationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deprecationDate", deprecationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ActivityTypeInfo
  ) extends zio.aws.swf.model.ActivityTypeInfo.ReadOnly {
    override val activityType: zio.aws.swf.model.ActivityType.ReadOnly =
      zio.aws.swf.model.ActivityType.wrap(impl.activityType())
    override val status: zio.aws.swf.model.RegistrationStatus =
      zio.aws.swf.model.RegistrationStatus.wrap(impl.status())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.swf.model.primitives.Description(value))
    override val creationDate: Timestamp =
      zio.aws.swf.model.primitives.Timestamp(impl.creationDate())
    override val deprecationDate: Option[Timestamp] = scala
      .Option(impl.deprecationDate())
      .map(value => zio.aws.swf.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ActivityTypeInfo
  ): zio.aws.swf.model.ActivityTypeInfo.ReadOnly = new Wrapper(impl)
}
