package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{DurationInSeconds, Data, TimerId}
import scala.jdk.CollectionConverters._
final case class StartTimerDecisionAttributes(
    timerId: TimerId,
    control: Option[Data] = None,
    startToFireTimeout: DurationInSeconds
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.StartTimerDecisionAttributes = {
    import StartTimerDecisionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.StartTimerDecisionAttributes
      .builder()
      .timerId(TimerId.unwrap(timerId): java.lang.String)
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .startToFireTimeout(
        DurationInSeconds.unwrap(startToFireTimeout): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.swf.model.StartTimerDecisionAttributes.ReadOnly =
    zio.aws.swf.model.StartTimerDecisionAttributes.wrap(buildAwsValue())
}
object StartTimerDecisionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.StartTimerDecisionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.StartTimerDecisionAttributes =
      zio.aws.swf.model.StartTimerDecisionAttributes(
        timerId,
        control.map(value => value),
        startToFireTimeout
      )
    def timerId: TimerId
    def control: Option[Data]
    def startToFireTimeout: DurationInSeconds
    def getTimerId: ZIO[Any, Nothing, TimerId] = ZIO.succeed(timerId)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
    def getStartToFireTimeout: ZIO[Any, Nothing, DurationInSeconds] =
      ZIO.succeed(startToFireTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.StartTimerDecisionAttributes
  ) extends zio.aws.swf.model.StartTimerDecisionAttributes.ReadOnly {
    override val timerId: TimerId =
      zio.aws.swf.model.primitives.TimerId(impl.timerId())
    override val control: Option[Data] = scala
      .Option(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val startToFireTimeout: DurationInSeconds =
      zio.aws.swf.model.primitives.DurationInSeconds(impl.startToFireTimeout())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.StartTimerDecisionAttributes
  ): zio.aws.swf.model.StartTimerDecisionAttributes.ReadOnly = new Wrapper(impl)
}
