package zio.aws.swf.model
import scala.jdk.CollectionConverters._
sealed trait EventType {
  def unwrap: software.amazon.awssdk.services.swf.model.EventType
}
object EventType {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.EventType
  ): zio.aws.swf.model.EventType = value match {
    case software.amazon.awssdk.services.swf.model.EventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_STARTED =>
      val r = WorkflowExecutionStarted
      r
    case software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_CANCEL_REQUESTED =>
      val r = WorkflowExecutionCancelRequested
      r
    case software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_COMPLETED =>
      val r = WorkflowExecutionCompleted
      r
    case software.amazon.awssdk.services.swf.model.EventType.COMPLETE_WORKFLOW_EXECUTION_FAILED =>
      val r = CompleteWorkflowExecutionFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_FAILED =>
      val r = WorkflowExecutionFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.FAIL_WORKFLOW_EXECUTION_FAILED =>
      val r = FailWorkflowExecutionFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_TIMED_OUT =>
      val r = WorkflowExecutionTimedOut
      r
    case software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_CANCELED =>
      val r = WorkflowExecutionCanceled
      r
    case software.amazon.awssdk.services.swf.model.EventType.CANCEL_WORKFLOW_EXECUTION_FAILED =>
      val r = CancelWorkflowExecutionFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_CONTINUED_AS_NEW =>
      val r = WorkflowExecutionContinuedAsNew
      r
    case software.amazon.awssdk.services.swf.model.EventType.CONTINUE_AS_NEW_WORKFLOW_EXECUTION_FAILED =>
      val r = ContinueAsNewWorkflowExecutionFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_TERMINATED =>
      val r = WorkflowExecutionTerminated
      r
    case software.amazon.awssdk.services.swf.model.EventType.DECISION_TASK_SCHEDULED =>
      val r = DecisionTaskScheduled
      r
    case software.amazon.awssdk.services.swf.model.EventType.DECISION_TASK_STARTED =>
      val r = DecisionTaskStarted
      r
    case software.amazon.awssdk.services.swf.model.EventType.DECISION_TASK_COMPLETED =>
      val r = DecisionTaskCompleted
      r
    case software.amazon.awssdk.services.swf.model.EventType.DECISION_TASK_TIMED_OUT =>
      val r = DecisionTaskTimedOut
      r
    case software.amazon.awssdk.services.swf.model.EventType.ACTIVITY_TASK_SCHEDULED =>
      val r = ActivityTaskScheduled
      r
    case software.amazon.awssdk.services.swf.model.EventType.SCHEDULE_ACTIVITY_TASK_FAILED =>
      val r = ScheduleActivityTaskFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.ACTIVITY_TASK_STARTED =>
      val r = ActivityTaskStarted
      r
    case software.amazon.awssdk.services.swf.model.EventType.ACTIVITY_TASK_COMPLETED =>
      val r = ActivityTaskCompleted
      r
    case software.amazon.awssdk.services.swf.model.EventType.ACTIVITY_TASK_FAILED =>
      val r = ActivityTaskFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.ACTIVITY_TASK_TIMED_OUT =>
      val r = ActivityTaskTimedOut
      r
    case software.amazon.awssdk.services.swf.model.EventType.ACTIVITY_TASK_CANCELED =>
      val r = ActivityTaskCanceled
      r
    case software.amazon.awssdk.services.swf.model.EventType.ACTIVITY_TASK_CANCEL_REQUESTED =>
      val r = ActivityTaskCancelRequested
      r
    case software.amazon.awssdk.services.swf.model.EventType.REQUEST_CANCEL_ACTIVITY_TASK_FAILED =>
      val r = RequestCancelActivityTaskFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_SIGNALED =>
      val r = WorkflowExecutionSignaled
      r
    case software.amazon.awssdk.services.swf.model.EventType.MARKER_RECORDED =>
      val r = MarkerRecorded
      r
    case software.amazon.awssdk.services.swf.model.EventType.RECORD_MARKER_FAILED =>
      val r = RecordMarkerFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.TIMER_STARTED =>
      val r = TimerStarted
      r
    case software.amazon.awssdk.services.swf.model.EventType.START_TIMER_FAILED =>
      val r = StartTimerFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.TIMER_FIRED =>
      val r = TimerFired
      r
    case software.amazon.awssdk.services.swf.model.EventType.TIMER_CANCELED =>
      val r = TimerCanceled
      r
    case software.amazon.awssdk.services.swf.model.EventType.CANCEL_TIMER_FAILED =>
      val r = CancelTimerFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.START_CHILD_WORKFLOW_EXECUTION_INITIATED =>
      val r = StartChildWorkflowExecutionInitiated
      r
    case software.amazon.awssdk.services.swf.model.EventType.START_CHILD_WORKFLOW_EXECUTION_FAILED =>
      val r = StartChildWorkflowExecutionFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.CHILD_WORKFLOW_EXECUTION_STARTED =>
      val r = ChildWorkflowExecutionStarted
      r
    case software.amazon.awssdk.services.swf.model.EventType.CHILD_WORKFLOW_EXECUTION_COMPLETED =>
      val r = ChildWorkflowExecutionCompleted
      r
    case software.amazon.awssdk.services.swf.model.EventType.CHILD_WORKFLOW_EXECUTION_FAILED =>
      val r = ChildWorkflowExecutionFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.CHILD_WORKFLOW_EXECUTION_TIMED_OUT =>
      val r = ChildWorkflowExecutionTimedOut
      r
    case software.amazon.awssdk.services.swf.model.EventType.CHILD_WORKFLOW_EXECUTION_CANCELED =>
      val r = ChildWorkflowExecutionCanceled
      r
    case software.amazon.awssdk.services.swf.model.EventType.CHILD_WORKFLOW_EXECUTION_TERMINATED =>
      val r = ChildWorkflowExecutionTerminated
      r
    case software.amazon.awssdk.services.swf.model.EventType.SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED =>
      val r = SignalExternalWorkflowExecutionInitiated
      r
    case software.amazon.awssdk.services.swf.model.EventType.SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED =>
      val r = SignalExternalWorkflowExecutionFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.EXTERNAL_WORKFLOW_EXECUTION_SIGNALED =>
      val r = ExternalWorkflowExecutionSignaled
      r
    case software.amazon.awssdk.services.swf.model.EventType.REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED =>
      val r = RequestCancelExternalWorkflowExecutionInitiated
      r
    case software.amazon.awssdk.services.swf.model.EventType.REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_FAILED =>
      val r = RequestCancelExternalWorkflowExecutionFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.EXTERNAL_WORKFLOW_EXECUTION_CANCEL_REQUESTED =>
      val r = ExternalWorkflowExecutionCancelRequested
      r
    case software.amazon.awssdk.services.swf.model.EventType.LAMBDA_FUNCTION_SCHEDULED =>
      val r = LambdaFunctionScheduled
      r
    case software.amazon.awssdk.services.swf.model.EventType.LAMBDA_FUNCTION_STARTED =>
      val r = LambdaFunctionStarted
      r
    case software.amazon.awssdk.services.swf.model.EventType.LAMBDA_FUNCTION_COMPLETED =>
      val r = LambdaFunctionCompleted
      r
    case software.amazon.awssdk.services.swf.model.EventType.LAMBDA_FUNCTION_FAILED =>
      val r = LambdaFunctionFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.LAMBDA_FUNCTION_TIMED_OUT =>
      val r = LambdaFunctionTimedOut
      r
    case software.amazon.awssdk.services.swf.model.EventType.SCHEDULE_LAMBDA_FUNCTION_FAILED =>
      val r = ScheduleLambdaFunctionFailed
      r
    case software.amazon.awssdk.services.swf.model.EventType.START_LAMBDA_FUNCTION_FAILED =>
      val r = StartLambdaFunctionFailed
      r
  }
  case object unknownToSdkVersion extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.UNKNOWN_TO_SDK_VERSION
  }
  case object WorkflowExecutionStarted extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_STARTED
  }
  case object WorkflowExecutionCancelRequested
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_CANCEL_REQUESTED
  }
  case object WorkflowExecutionCompleted extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_COMPLETED
  }
  case object CompleteWorkflowExecutionFailed
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.COMPLETE_WORKFLOW_EXECUTION_FAILED
  }
  case object WorkflowExecutionFailed extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_FAILED
  }
  case object FailWorkflowExecutionFailed extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.FAIL_WORKFLOW_EXECUTION_FAILED
  }
  case object WorkflowExecutionTimedOut extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_TIMED_OUT
  }
  case object WorkflowExecutionCanceled extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_CANCELED
  }
  case object CancelWorkflowExecutionFailed
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.CANCEL_WORKFLOW_EXECUTION_FAILED
  }
  case object WorkflowExecutionContinuedAsNew
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_CONTINUED_AS_NEW
  }
  case object ContinueAsNewWorkflowExecutionFailed
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.CONTINUE_AS_NEW_WORKFLOW_EXECUTION_FAILED
  }
  case object WorkflowExecutionTerminated extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_TERMINATED
  }
  case object DecisionTaskScheduled extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.DECISION_TASK_SCHEDULED
  }
  case object DecisionTaskStarted extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.DECISION_TASK_STARTED
  }
  case object DecisionTaskCompleted extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.DECISION_TASK_COMPLETED
  }
  case object DecisionTaskTimedOut extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.DECISION_TASK_TIMED_OUT
  }
  case object ActivityTaskScheduled extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.ACTIVITY_TASK_SCHEDULED
  }
  case object ScheduleActivityTaskFailed extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.SCHEDULE_ACTIVITY_TASK_FAILED
  }
  case object ActivityTaskStarted extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.ACTIVITY_TASK_STARTED
  }
  case object ActivityTaskCompleted extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.ACTIVITY_TASK_COMPLETED
  }
  case object ActivityTaskFailed extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.ACTIVITY_TASK_FAILED
  }
  case object ActivityTaskTimedOut extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.ACTIVITY_TASK_TIMED_OUT
  }
  case object ActivityTaskCanceled extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.ACTIVITY_TASK_CANCELED
  }
  case object ActivityTaskCancelRequested extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.ACTIVITY_TASK_CANCEL_REQUESTED
  }
  case object RequestCancelActivityTaskFailed
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.REQUEST_CANCEL_ACTIVITY_TASK_FAILED
  }
  case object WorkflowExecutionSignaled extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.WORKFLOW_EXECUTION_SIGNALED
  }
  case object MarkerRecorded extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.MARKER_RECORDED
  }
  case object RecordMarkerFailed extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.RECORD_MARKER_FAILED
  }
  case object TimerStarted extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.TIMER_STARTED
  }
  case object StartTimerFailed extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.START_TIMER_FAILED
  }
  case object TimerFired extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.TIMER_FIRED
  }
  case object TimerCanceled extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.TIMER_CANCELED
  }
  case object CancelTimerFailed extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.CANCEL_TIMER_FAILED
  }
  case object StartChildWorkflowExecutionInitiated
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.START_CHILD_WORKFLOW_EXECUTION_INITIATED
  }
  case object StartChildWorkflowExecutionFailed
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.START_CHILD_WORKFLOW_EXECUTION_FAILED
  }
  case object ChildWorkflowExecutionStarted
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.CHILD_WORKFLOW_EXECUTION_STARTED
  }
  case object ChildWorkflowExecutionCompleted
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.CHILD_WORKFLOW_EXECUTION_COMPLETED
  }
  case object ChildWorkflowExecutionFailed extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.CHILD_WORKFLOW_EXECUTION_FAILED
  }
  case object ChildWorkflowExecutionTimedOut
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.CHILD_WORKFLOW_EXECUTION_TIMED_OUT
  }
  case object ChildWorkflowExecutionCanceled
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.CHILD_WORKFLOW_EXECUTION_CANCELED
  }
  case object ChildWorkflowExecutionTerminated
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.CHILD_WORKFLOW_EXECUTION_TERMINATED
  }
  case object SignalExternalWorkflowExecutionInitiated
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED
  }
  case object SignalExternalWorkflowExecutionFailed
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED
  }
  case object ExternalWorkflowExecutionSignaled
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.EXTERNAL_WORKFLOW_EXECUTION_SIGNALED
  }
  case object RequestCancelExternalWorkflowExecutionInitiated
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED
  }
  case object RequestCancelExternalWorkflowExecutionFailed
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_FAILED
  }
  case object ExternalWorkflowExecutionCancelRequested
      extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.EXTERNAL_WORKFLOW_EXECUTION_CANCEL_REQUESTED
  }
  case object LambdaFunctionScheduled extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.LAMBDA_FUNCTION_SCHEDULED
  }
  case object LambdaFunctionStarted extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.LAMBDA_FUNCTION_STARTED
  }
  case object LambdaFunctionCompleted extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.LAMBDA_FUNCTION_COMPLETED
  }
  case object LambdaFunctionFailed extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.LAMBDA_FUNCTION_FAILED
  }
  case object LambdaFunctionTimedOut extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.LAMBDA_FUNCTION_TIMED_OUT
  }
  case object ScheduleLambdaFunctionFailed extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.SCHEDULE_LAMBDA_FUNCTION_FAILED
  }
  case object StartLambdaFunctionFailed extends zio.aws.swf.model.EventType {
    override def unwrap: software.amazon.awssdk.services.swf.model.EventType =
      software.amazon.awssdk.services.swf.model.EventType.START_LAMBDA_FUNCTION_FAILED
  }
}
