package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.DomainName
import scala.jdk.CollectionConverters._
final case class DescribeActivityTypeRequest(
    domain: DomainName,
    activityType: zio.aws.swf.model.ActivityType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.DescribeActivityTypeRequest = {
    import DescribeActivityTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DescribeActivityTypeRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .activityType(activityType.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.swf.model.DescribeActivityTypeRequest.ReadOnly =
    zio.aws.swf.model.DescribeActivityTypeRequest.wrap(buildAwsValue())
}
object DescribeActivityTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.DescribeActivityTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DescribeActivityTypeRequest =
      zio.aws.swf.model
        .DescribeActivityTypeRequest(domain, activityType.asEditable)
    def domain: DomainName
    def activityType: zio.aws.swf.model.ActivityType.ReadOnly
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getActivityType
        : ZIO[Any, Nothing, zio.aws.swf.model.ActivityType.ReadOnly] =
      ZIO.succeed(activityType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DescribeActivityTypeRequest
  ) extends zio.aws.swf.model.DescribeActivityTypeRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val activityType: zio.aws.swf.model.ActivityType.ReadOnly =
      zio.aws.swf.model.ActivityType.wrap(impl.activityType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DescribeActivityTypeRequest
  ): zio.aws.swf.model.DescribeActivityTypeRequest.ReadOnly = new Wrapper(impl)
}
