package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{Data, WorkflowRunIdOptional, WorkflowId}
import scala.jdk.CollectionConverters._
final case class RequestCancelExternalWorkflowExecutionDecisionAttributes(
    workflowId: WorkflowId,
    runId: Option[WorkflowRunIdOptional] = None,
    control: Option[Data] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes = {
    import RequestCancelExternalWorkflowExecutionDecisionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes
      .builder()
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .optionallyWith(
        runId.map(value =>
          WorkflowRunIdOptional.unwrap(value): java.lang.String
        )
      )(_.runId)
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes.ReadOnly =
    zio.aws.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes
      .wrap(buildAwsValue())
}
object RequestCancelExternalWorkflowExecutionDecisionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes =
      zio.aws.swf.model
        .RequestCancelExternalWorkflowExecutionDecisionAttributes(
          workflowId,
          runId.map(value => value),
          control.map(value => value)
        )
    def workflowId: WorkflowId
    def runId: Option[WorkflowRunIdOptional]
    def control: Option[Data]
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getRunId: ZIO[Any, AwsError, WorkflowRunIdOptional] =
      AwsError.unwrapOptionField("runId", runId)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes
  ) extends zio.aws.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes.ReadOnly {
    override val workflowId: WorkflowId =
      zio.aws.swf.model.primitives.WorkflowId(impl.workflowId())
    override val runId: Option[WorkflowRunIdOptional] = scala
      .Option(impl.runId())
      .map(value => zio.aws.swf.model.primitives.WorkflowRunIdOptional(value))
    override val control: Option[Data] = scala
      .Option(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes
  ): zio.aws.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes.ReadOnly =
    new Wrapper(impl)
}
