package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{EventId, Data}
import scala.jdk.CollectionConverters._
final case class WorkflowExecutionCanceledEventAttributes(
    details: Option[Data] = None,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowExecutionCanceledEventAttributes = {
    import WorkflowExecutionCanceledEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowExecutionCanceledEventAttributes
      .builder()
      .optionallyWith(
        details.map(value => Data.unwrap(value): java.lang.String)
      )(_.details)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.WorkflowExecutionCanceledEventAttributes.ReadOnly =
    zio.aws.swf.model.WorkflowExecutionCanceledEventAttributes
      .wrap(buildAwsValue())
}
object WorkflowExecutionCanceledEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowExecutionCanceledEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.WorkflowExecutionCanceledEventAttributes =
      zio.aws.swf.model.WorkflowExecutionCanceledEventAttributes(
        details.map(value => value),
        decisionTaskCompletedEventId
      )
    def details: Option[Data]
    def decisionTaskCompletedEventId: EventId
    def getDetails: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("details", details)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionCanceledEventAttributes
  ) extends zio.aws.swf.model.WorkflowExecutionCanceledEventAttributes.ReadOnly {
    override val details: Option[Data] = scala
      .Option(impl.details())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionCanceledEventAttributes
  ): zio.aws.swf.model.WorkflowExecutionCanceledEventAttributes.ReadOnly =
    new Wrapper(impl)
}
