package zio.aws.swf.model
import scala.jdk.CollectionConverters._
sealed trait RegistrationStatus {
  def unwrap: software.amazon.awssdk.services.swf.model.RegistrationStatus
}
object RegistrationStatus {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.RegistrationStatus
  ): zio.aws.swf.model.RegistrationStatus = value match {
    case software.amazon.awssdk.services.swf.model.RegistrationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.swf.model.RegistrationStatus.REGISTERED =>
      val r = REGISTERED
      r
    case software.amazon.awssdk.services.swf.model.RegistrationStatus.DEPRECATED =>
      val r = DEPRECATED
      r
  }
  case object unknownToSdkVersion extends zio.aws.swf.model.RegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.RegistrationStatus =
      software.amazon.awssdk.services.swf.model.RegistrationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object REGISTERED extends zio.aws.swf.model.RegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.RegistrationStatus =
      software.amazon.awssdk.services.swf.model.RegistrationStatus.REGISTERED
  }
  case object DEPRECATED extends zio.aws.swf.model.RegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.RegistrationStatus =
      software.amazon.awssdk.services.swf.model.RegistrationStatus.DEPRECATED
  }
}
