package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.EventId
import scala.jdk.CollectionConverters._
final case class ContinueAsNewWorkflowExecutionFailedEventAttributes(
    cause: zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedCause,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes = {
    import ContinueAsNewWorkflowExecutionFailedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes
      .builder()
      .cause(cause.unwrap)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes.ReadOnly =
    zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes
      .wrap(buildAwsValue())
}
object ContinueAsNewWorkflowExecutionFailedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes =
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes(
        cause,
        decisionTaskCompletedEventId
      )
    def cause: zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedCause
    def decisionTaskCompletedEventId: EventId
    def getCause: ZIO[
      Any,
      Nothing,
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedCause
    ] = ZIO.succeed(cause)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes
  ) extends zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes.ReadOnly {
    override val cause
        : zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedCause =
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedCause
        .wrap(impl.cause())
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes
  ): zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
