package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.Name
import scala.jdk.CollectionConverters._
final case class TaskList(name: Name) {
  def buildAwsValue(): software.amazon.awssdk.services.swf.model.TaskList = {
    import TaskList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.TaskList
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.TaskList.ReadOnly =
    zio.aws.swf.model.TaskList.wrap(buildAwsValue())
}
object TaskList {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.swf.model.TaskList] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.TaskList =
      zio.aws.swf.model.TaskList(name)
    def name: Name
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.TaskList
  ) extends zio.aws.swf.model.TaskList.ReadOnly {
    override val name: Name = zio.aws.swf.model.primitives.Name(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.TaskList
  ): zio.aws.swf.model.TaskList.ReadOnly = new Wrapper(impl)
}
