package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.Data
import scala.jdk.CollectionConverters._
final case class CompleteWorkflowExecutionDecisionAttributes(
    result: Option[Data] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.CompleteWorkflowExecutionDecisionAttributes = {
    import CompleteWorkflowExecutionDecisionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.CompleteWorkflowExecutionDecisionAttributes
      .builder()
      .optionallyWith(
        result.map(value => Data.unwrap(value): java.lang.String)
      )(_.result)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.CompleteWorkflowExecutionDecisionAttributes.ReadOnly =
    zio.aws.swf.model.CompleteWorkflowExecutionDecisionAttributes
      .wrap(buildAwsValue())
}
object CompleteWorkflowExecutionDecisionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.CompleteWorkflowExecutionDecisionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.CompleteWorkflowExecutionDecisionAttributes =
      zio.aws.swf.model
        .CompleteWorkflowExecutionDecisionAttributes(result.map(value => value))
    def result: Option[Data]
    def getResult: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("result", result)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.CompleteWorkflowExecutionDecisionAttributes
  ) extends zio.aws.swf.model.CompleteWorkflowExecutionDecisionAttributes.ReadOnly {
    override val result: Option[Data] = scala
      .Option(impl.result())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.CompleteWorkflowExecutionDecisionAttributes
  ): zio.aws.swf.model.CompleteWorkflowExecutionDecisionAttributes.ReadOnly =
    new Wrapper(impl)
}
