package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.swf.model.primitives.{
  Data,
  SignalName,
  WorkflowRunIdOptional,
  WorkflowId
}
import scala.jdk.CollectionConverters._
final case class SignalExternalWorkflowExecutionDecisionAttributes(
    workflowId: WorkflowId,
    runId: Option[WorkflowRunIdOptional] = None,
    signalName: SignalName,
    input: Option[Data] = None,
    control: Option[Data] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionDecisionAttributes = {
    import SignalExternalWorkflowExecutionDecisionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionDecisionAttributes
      .builder()
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .optionallyWith(
        runId.map(value =>
          WorkflowRunIdOptional.unwrap(value): java.lang.String
        )
      )(_.runId)
      .signalName(SignalName.unwrap(signalName): java.lang.String)
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.SignalExternalWorkflowExecutionDecisionAttributes.ReadOnly =
    zio.aws.swf.model.SignalExternalWorkflowExecutionDecisionAttributes
      .wrap(buildAwsValue())
}
object SignalExternalWorkflowExecutionDecisionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionDecisionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.SignalExternalWorkflowExecutionDecisionAttributes =
      zio.aws.swf.model.SignalExternalWorkflowExecutionDecisionAttributes(
        workflowId,
        runId.map(value => value),
        signalName,
        input.map(value => value),
        control.map(value => value)
      )
    def workflowId: WorkflowId
    def runId: Option[WorkflowRunIdOptional]
    def signalName: SignalName
    def input: Option[Data]
    def control: Option[Data]
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getRunId: ZIO[Any, AwsError, WorkflowRunIdOptional] =
      AwsError.unwrapOptionField("runId", runId)
    def getSignalName: ZIO[Any, Nothing, SignalName] = ZIO.succeed(signalName)
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionDecisionAttributes
  ) extends zio.aws.swf.model.SignalExternalWorkflowExecutionDecisionAttributes.ReadOnly {
    override val workflowId: WorkflowId =
      zio.aws.swf.model.primitives.WorkflowId(impl.workflowId())
    override val runId: Option[WorkflowRunIdOptional] = scala
      .Option(impl.runId())
      .map(value => zio.aws.swf.model.primitives.WorkflowRunIdOptional(value))
    override val signalName: SignalName =
      zio.aws.swf.model.primitives.SignalName(impl.signalName())
    override val input: Option[Data] = scala
      .Option(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val control: Option[Data] = scala
      .Option(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionDecisionAttributes
  ): zio.aws.swf.model.SignalExternalWorkflowExecutionDecisionAttributes.ReadOnly =
    new Wrapper(impl)
}
