package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.swf.model.primitives.{EventId, Timestamp}
import scala.jdk.CollectionConverters._
final case class HistoryEvent(
    eventTimestamp: Timestamp,
    eventType: zio.aws.swf.model.EventType,
    eventId: EventId,
    workflowExecutionStartedEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionStartedEventAttributes
    ] = None,
    workflowExecutionCompletedEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionCompletedEventAttributes
    ] = None,
    completeWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.CompleteWorkflowExecutionFailedEventAttributes
    ] = None,
    workflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionFailedEventAttributes
    ] = None,
    failWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.FailWorkflowExecutionFailedEventAttributes
    ] = None,
    workflowExecutionTimedOutEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionTimedOutEventAttributes
    ] = None,
    workflowExecutionCanceledEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionCanceledEventAttributes
    ] = None,
    cancelWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.CancelWorkflowExecutionFailedEventAttributes
    ] = None,
    workflowExecutionContinuedAsNewEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionContinuedAsNewEventAttributes
    ] = None,
    continueAsNewWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes
    ] = None,
    workflowExecutionTerminatedEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionTerminatedEventAttributes
    ] = None,
    workflowExecutionCancelRequestedEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionCancelRequestedEventAttributes
    ] = None,
    decisionTaskScheduledEventAttributes: Option[
      zio.aws.swf.model.DecisionTaskScheduledEventAttributes
    ] = None,
    decisionTaskStartedEventAttributes: Option[
      zio.aws.swf.model.DecisionTaskStartedEventAttributes
    ] = None,
    decisionTaskCompletedEventAttributes: Option[
      zio.aws.swf.model.DecisionTaskCompletedEventAttributes
    ] = None,
    decisionTaskTimedOutEventAttributes: Option[
      zio.aws.swf.model.DecisionTaskTimedOutEventAttributes
    ] = None,
    activityTaskScheduledEventAttributes: Option[
      zio.aws.swf.model.ActivityTaskScheduledEventAttributes
    ] = None,
    activityTaskStartedEventAttributes: Option[
      zio.aws.swf.model.ActivityTaskStartedEventAttributes
    ] = None,
    activityTaskCompletedEventAttributes: Option[
      zio.aws.swf.model.ActivityTaskCompletedEventAttributes
    ] = None,
    activityTaskFailedEventAttributes: Option[
      zio.aws.swf.model.ActivityTaskFailedEventAttributes
    ] = None,
    activityTaskTimedOutEventAttributes: Option[
      zio.aws.swf.model.ActivityTaskTimedOutEventAttributes
    ] = None,
    activityTaskCanceledEventAttributes: Option[
      zio.aws.swf.model.ActivityTaskCanceledEventAttributes
    ] = None,
    activityTaskCancelRequestedEventAttributes: Option[
      zio.aws.swf.model.ActivityTaskCancelRequestedEventAttributes
    ] = None,
    workflowExecutionSignaledEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionSignaledEventAttributes
    ] = None,
    markerRecordedEventAttributes: Option[
      zio.aws.swf.model.MarkerRecordedEventAttributes
    ] = None,
    recordMarkerFailedEventAttributes: Option[
      zio.aws.swf.model.RecordMarkerFailedEventAttributes
    ] = None,
    timerStartedEventAttributes: Option[
      zio.aws.swf.model.TimerStartedEventAttributes
    ] = None,
    timerFiredEventAttributes: Option[
      zio.aws.swf.model.TimerFiredEventAttributes
    ] = None,
    timerCanceledEventAttributes: Option[
      zio.aws.swf.model.TimerCanceledEventAttributes
    ] = None,
    startChildWorkflowExecutionInitiatedEventAttributes: Option[
      zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes
    ] = None,
    childWorkflowExecutionStartedEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionStartedEventAttributes
    ] = None,
    childWorkflowExecutionCompletedEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionCompletedEventAttributes
    ] = None,
    childWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionFailedEventAttributes
    ] = None,
    childWorkflowExecutionTimedOutEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionTimedOutEventAttributes
    ] = None,
    childWorkflowExecutionCanceledEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionCanceledEventAttributes
    ] = None,
    childWorkflowExecutionTerminatedEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionTerminatedEventAttributes
    ] = None,
    signalExternalWorkflowExecutionInitiatedEventAttributes: Option[
      zio.aws.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes
    ] = None,
    externalWorkflowExecutionSignaledEventAttributes: Option[
      zio.aws.swf.model.ExternalWorkflowExecutionSignaledEventAttributes
    ] = None,
    signalExternalWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes
    ] = None,
    externalWorkflowExecutionCancelRequestedEventAttributes: Option[
      zio.aws.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes
    ] = None,
    requestCancelExternalWorkflowExecutionInitiatedEventAttributes: Option[
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
    ] = None,
    requestCancelExternalWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes
    ] = None,
    scheduleActivityTaskFailedEventAttributes: Option[
      zio.aws.swf.model.ScheduleActivityTaskFailedEventAttributes
    ] = None,
    requestCancelActivityTaskFailedEventAttributes: Option[
      zio.aws.swf.model.RequestCancelActivityTaskFailedEventAttributes
    ] = None,
    startTimerFailedEventAttributes: Option[
      zio.aws.swf.model.StartTimerFailedEventAttributes
    ] = None,
    cancelTimerFailedEventAttributes: Option[
      zio.aws.swf.model.CancelTimerFailedEventAttributes
    ] = None,
    startChildWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.StartChildWorkflowExecutionFailedEventAttributes
    ] = None,
    lambdaFunctionScheduledEventAttributes: Option[
      zio.aws.swf.model.LambdaFunctionScheduledEventAttributes
    ] = None,
    lambdaFunctionStartedEventAttributes: Option[
      zio.aws.swf.model.LambdaFunctionStartedEventAttributes
    ] = None,
    lambdaFunctionCompletedEventAttributes: Option[
      zio.aws.swf.model.LambdaFunctionCompletedEventAttributes
    ] = None,
    lambdaFunctionFailedEventAttributes: Option[
      zio.aws.swf.model.LambdaFunctionFailedEventAttributes
    ] = None,
    lambdaFunctionTimedOutEventAttributes: Option[
      zio.aws.swf.model.LambdaFunctionTimedOutEventAttributes
    ] = None,
    scheduleLambdaFunctionFailedEventAttributes: Option[
      zio.aws.swf.model.ScheduleLambdaFunctionFailedEventAttributes
    ] = None,
    startLambdaFunctionFailedEventAttributes: Option[
      zio.aws.swf.model.StartLambdaFunctionFailedEventAttributes
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.HistoryEvent = {
    import HistoryEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.HistoryEvent
      .builder()
      .eventTimestamp(Timestamp.unwrap(eventTimestamp): Instant)
      .eventType(eventType.unwrap)
      .eventId(EventId.unwrap(eventId): java.lang.Long)
      .optionallyWith(
        workflowExecutionStartedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionStartedEventAttributes)
      .optionallyWith(
        workflowExecutionCompletedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionCompletedEventAttributes)
      .optionallyWith(
        completeWorkflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.completeWorkflowExecutionFailedEventAttributes)
      .optionallyWith(
        workflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionFailedEventAttributes)
      .optionallyWith(
        failWorkflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.failWorkflowExecutionFailedEventAttributes)
      .optionallyWith(
        workflowExecutionTimedOutEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionTimedOutEventAttributes)
      .optionallyWith(
        workflowExecutionCanceledEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionCanceledEventAttributes)
      .optionallyWith(
        cancelWorkflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.cancelWorkflowExecutionFailedEventAttributes)
      .optionallyWith(
        workflowExecutionContinuedAsNewEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionContinuedAsNewEventAttributes)
      .optionallyWith(
        continueAsNewWorkflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.continueAsNewWorkflowExecutionFailedEventAttributes)
      .optionallyWith(
        workflowExecutionTerminatedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionTerminatedEventAttributes)
      .optionallyWith(
        workflowExecutionCancelRequestedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionCancelRequestedEventAttributes)
      .optionallyWith(
        decisionTaskScheduledEventAttributes.map(value => value.buildAwsValue())
      )(_.decisionTaskScheduledEventAttributes)
      .optionallyWith(
        decisionTaskStartedEventAttributes.map(value => value.buildAwsValue())
      )(_.decisionTaskStartedEventAttributes)
      .optionallyWith(
        decisionTaskCompletedEventAttributes.map(value => value.buildAwsValue())
      )(_.decisionTaskCompletedEventAttributes)
      .optionallyWith(
        decisionTaskTimedOutEventAttributes.map(value => value.buildAwsValue())
      )(_.decisionTaskTimedOutEventAttributes)
      .optionallyWith(
        activityTaskScheduledEventAttributes.map(value => value.buildAwsValue())
      )(_.activityTaskScheduledEventAttributes)
      .optionallyWith(
        activityTaskStartedEventAttributes.map(value => value.buildAwsValue())
      )(_.activityTaskStartedEventAttributes)
      .optionallyWith(
        activityTaskCompletedEventAttributes.map(value => value.buildAwsValue())
      )(_.activityTaskCompletedEventAttributes)
      .optionallyWith(
        activityTaskFailedEventAttributes.map(value => value.buildAwsValue())
      )(_.activityTaskFailedEventAttributes)
      .optionallyWith(
        activityTaskTimedOutEventAttributes.map(value => value.buildAwsValue())
      )(_.activityTaskTimedOutEventAttributes)
      .optionallyWith(
        activityTaskCanceledEventAttributes.map(value => value.buildAwsValue())
      )(_.activityTaskCanceledEventAttributes)
      .optionallyWith(
        activityTaskCancelRequestedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.activityTaskCancelRequestedEventAttributes)
      .optionallyWith(
        workflowExecutionSignaledEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.workflowExecutionSignaledEventAttributes)
      .optionallyWith(
        markerRecordedEventAttributes.map(value => value.buildAwsValue())
      )(_.markerRecordedEventAttributes)
      .optionallyWith(
        recordMarkerFailedEventAttributes.map(value => value.buildAwsValue())
      )(_.recordMarkerFailedEventAttributes)
      .optionallyWith(
        timerStartedEventAttributes.map(value => value.buildAwsValue())
      )(_.timerStartedEventAttributes)
      .optionallyWith(
        timerFiredEventAttributes.map(value => value.buildAwsValue())
      )(_.timerFiredEventAttributes)
      .optionallyWith(
        timerCanceledEventAttributes.map(value => value.buildAwsValue())
      )(_.timerCanceledEventAttributes)
      .optionallyWith(
        startChildWorkflowExecutionInitiatedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.startChildWorkflowExecutionInitiatedEventAttributes)
      .optionallyWith(
        childWorkflowExecutionStartedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.childWorkflowExecutionStartedEventAttributes)
      .optionallyWith(
        childWorkflowExecutionCompletedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.childWorkflowExecutionCompletedEventAttributes)
      .optionallyWith(
        childWorkflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.childWorkflowExecutionFailedEventAttributes)
      .optionallyWith(
        childWorkflowExecutionTimedOutEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.childWorkflowExecutionTimedOutEventAttributes)
      .optionallyWith(
        childWorkflowExecutionCanceledEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.childWorkflowExecutionCanceledEventAttributes)
      .optionallyWith(
        childWorkflowExecutionTerminatedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.childWorkflowExecutionTerminatedEventAttributes)
      .optionallyWith(
        signalExternalWorkflowExecutionInitiatedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.signalExternalWorkflowExecutionInitiatedEventAttributes)
      .optionallyWith(
        externalWorkflowExecutionSignaledEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.externalWorkflowExecutionSignaledEventAttributes)
      .optionallyWith(
        signalExternalWorkflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.signalExternalWorkflowExecutionFailedEventAttributes)
      .optionallyWith(
        externalWorkflowExecutionCancelRequestedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.externalWorkflowExecutionCancelRequestedEventAttributes)
      .optionallyWith(
        requestCancelExternalWorkflowExecutionInitiatedEventAttributes.map(
          value => value.buildAwsValue()
        )
      )(_.requestCancelExternalWorkflowExecutionInitiatedEventAttributes)
      .optionallyWith(
        requestCancelExternalWorkflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.requestCancelExternalWorkflowExecutionFailedEventAttributes)
      .optionallyWith(
        scheduleActivityTaskFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.scheduleActivityTaskFailedEventAttributes)
      .optionallyWith(
        requestCancelActivityTaskFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.requestCancelActivityTaskFailedEventAttributes)
      .optionallyWith(
        startTimerFailedEventAttributes.map(value => value.buildAwsValue())
      )(_.startTimerFailedEventAttributes)
      .optionallyWith(
        cancelTimerFailedEventAttributes.map(value => value.buildAwsValue())
      )(_.cancelTimerFailedEventAttributes)
      .optionallyWith(
        startChildWorkflowExecutionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.startChildWorkflowExecutionFailedEventAttributes)
      .optionallyWith(
        lambdaFunctionScheduledEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.lambdaFunctionScheduledEventAttributes)
      .optionallyWith(
        lambdaFunctionStartedEventAttributes.map(value => value.buildAwsValue())
      )(_.lambdaFunctionStartedEventAttributes)
      .optionallyWith(
        lambdaFunctionCompletedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.lambdaFunctionCompletedEventAttributes)
      .optionallyWith(
        lambdaFunctionFailedEventAttributes.map(value => value.buildAwsValue())
      )(_.lambdaFunctionFailedEventAttributes)
      .optionallyWith(
        lambdaFunctionTimedOutEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.lambdaFunctionTimedOutEventAttributes)
      .optionallyWith(
        scheduleLambdaFunctionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.scheduleLambdaFunctionFailedEventAttributes)
      .optionallyWith(
        startLambdaFunctionFailedEventAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.startLambdaFunctionFailedEventAttributes)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.HistoryEvent.ReadOnly =
    zio.aws.swf.model.HistoryEvent.wrap(buildAwsValue())
}
object HistoryEvent {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.swf.model.HistoryEvent] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.HistoryEvent =
      zio.aws.swf.model.HistoryEvent(
        eventTimestamp,
        eventType,
        eventId,
        workflowExecutionStartedEventAttributes.map(value => value.asEditable),
        workflowExecutionCompletedEventAttributes.map(value =>
          value.asEditable
        ),
        completeWorkflowExecutionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        workflowExecutionFailedEventAttributes.map(value => value.asEditable),
        failWorkflowExecutionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        workflowExecutionTimedOutEventAttributes.map(value => value.asEditable),
        workflowExecutionCanceledEventAttributes.map(value => value.asEditable),
        cancelWorkflowExecutionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        workflowExecutionContinuedAsNewEventAttributes.map(value =>
          value.asEditable
        ),
        continueAsNewWorkflowExecutionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        workflowExecutionTerminatedEventAttributes.map(value =>
          value.asEditable
        ),
        workflowExecutionCancelRequestedEventAttributes.map(value =>
          value.asEditable
        ),
        decisionTaskScheduledEventAttributes.map(value => value.asEditable),
        decisionTaskStartedEventAttributes.map(value => value.asEditable),
        decisionTaskCompletedEventAttributes.map(value => value.asEditable),
        decisionTaskTimedOutEventAttributes.map(value => value.asEditable),
        activityTaskScheduledEventAttributes.map(value => value.asEditable),
        activityTaskStartedEventAttributes.map(value => value.asEditable),
        activityTaskCompletedEventAttributes.map(value => value.asEditable),
        activityTaskFailedEventAttributes.map(value => value.asEditable),
        activityTaskTimedOutEventAttributes.map(value => value.asEditable),
        activityTaskCanceledEventAttributes.map(value => value.asEditable),
        activityTaskCancelRequestedEventAttributes.map(value =>
          value.asEditable
        ),
        workflowExecutionSignaledEventAttributes.map(value => value.asEditable),
        markerRecordedEventAttributes.map(value => value.asEditable),
        recordMarkerFailedEventAttributes.map(value => value.asEditable),
        timerStartedEventAttributes.map(value => value.asEditable),
        timerFiredEventAttributes.map(value => value.asEditable),
        timerCanceledEventAttributes.map(value => value.asEditable),
        startChildWorkflowExecutionInitiatedEventAttributes.map(value =>
          value.asEditable
        ),
        childWorkflowExecutionStartedEventAttributes.map(value =>
          value.asEditable
        ),
        childWorkflowExecutionCompletedEventAttributes.map(value =>
          value.asEditable
        ),
        childWorkflowExecutionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        childWorkflowExecutionTimedOutEventAttributes.map(value =>
          value.asEditable
        ),
        childWorkflowExecutionCanceledEventAttributes.map(value =>
          value.asEditable
        ),
        childWorkflowExecutionTerminatedEventAttributes.map(value =>
          value.asEditable
        ),
        signalExternalWorkflowExecutionInitiatedEventAttributes.map(value =>
          value.asEditable
        ),
        externalWorkflowExecutionSignaledEventAttributes.map(value =>
          value.asEditable
        ),
        signalExternalWorkflowExecutionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        externalWorkflowExecutionCancelRequestedEventAttributes.map(value =>
          value.asEditable
        ),
        requestCancelExternalWorkflowExecutionInitiatedEventAttributes.map(
          value => value.asEditable
        ),
        requestCancelExternalWorkflowExecutionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        scheduleActivityTaskFailedEventAttributes.map(value =>
          value.asEditable
        ),
        requestCancelActivityTaskFailedEventAttributes.map(value =>
          value.asEditable
        ),
        startTimerFailedEventAttributes.map(value => value.asEditable),
        cancelTimerFailedEventAttributes.map(value => value.asEditable),
        startChildWorkflowExecutionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        lambdaFunctionScheduledEventAttributes.map(value => value.asEditable),
        lambdaFunctionStartedEventAttributes.map(value => value.asEditable),
        lambdaFunctionCompletedEventAttributes.map(value => value.asEditable),
        lambdaFunctionFailedEventAttributes.map(value => value.asEditable),
        lambdaFunctionTimedOutEventAttributes.map(value => value.asEditable),
        scheduleLambdaFunctionFailedEventAttributes.map(value =>
          value.asEditable
        ),
        startLambdaFunctionFailedEventAttributes.map(value => value.asEditable)
      )
    def eventTimestamp: Timestamp
    def eventType: zio.aws.swf.model.EventType
    def eventId: EventId
    def workflowExecutionStartedEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionStartedEventAttributes.ReadOnly
    ]
    def workflowExecutionCompletedEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionCompletedEventAttributes.ReadOnly
    ]
    def completeWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.CompleteWorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def workflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def failWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.FailWorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def workflowExecutionTimedOutEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionTimedOutEventAttributes.ReadOnly
    ]
    def workflowExecutionCanceledEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionCanceledEventAttributes.ReadOnly
    ]
    def cancelWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.CancelWorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def workflowExecutionContinuedAsNewEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionContinuedAsNewEventAttributes.ReadOnly
    ]
    def continueAsNewWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def workflowExecutionTerminatedEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionTerminatedEventAttributes.ReadOnly
    ]
    def workflowExecutionCancelRequestedEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionCancelRequestedEventAttributes.ReadOnly
    ]
    def decisionTaskScheduledEventAttributes: Option[
      zio.aws.swf.model.DecisionTaskScheduledEventAttributes.ReadOnly
    ]
    def decisionTaskStartedEventAttributes
        : Option[zio.aws.swf.model.DecisionTaskStartedEventAttributes.ReadOnly]
    def decisionTaskCompletedEventAttributes: Option[
      zio.aws.swf.model.DecisionTaskCompletedEventAttributes.ReadOnly
    ]
    def decisionTaskTimedOutEventAttributes
        : Option[zio.aws.swf.model.DecisionTaskTimedOutEventAttributes.ReadOnly]
    def activityTaskScheduledEventAttributes: Option[
      zio.aws.swf.model.ActivityTaskScheduledEventAttributes.ReadOnly
    ]
    def activityTaskStartedEventAttributes
        : Option[zio.aws.swf.model.ActivityTaskStartedEventAttributes.ReadOnly]
    def activityTaskCompletedEventAttributes: Option[
      zio.aws.swf.model.ActivityTaskCompletedEventAttributes.ReadOnly
    ]
    def activityTaskFailedEventAttributes
        : Option[zio.aws.swf.model.ActivityTaskFailedEventAttributes.ReadOnly]
    def activityTaskTimedOutEventAttributes
        : Option[zio.aws.swf.model.ActivityTaskTimedOutEventAttributes.ReadOnly]
    def activityTaskCanceledEventAttributes
        : Option[zio.aws.swf.model.ActivityTaskCanceledEventAttributes.ReadOnly]
    def activityTaskCancelRequestedEventAttributes: Option[
      zio.aws.swf.model.ActivityTaskCancelRequestedEventAttributes.ReadOnly
    ]
    def workflowExecutionSignaledEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionSignaledEventAttributes.ReadOnly
    ]
    def markerRecordedEventAttributes
        : Option[zio.aws.swf.model.MarkerRecordedEventAttributes.ReadOnly]
    def recordMarkerFailedEventAttributes
        : Option[zio.aws.swf.model.RecordMarkerFailedEventAttributes.ReadOnly]
    def timerStartedEventAttributes
        : Option[zio.aws.swf.model.TimerStartedEventAttributes.ReadOnly]
    def timerFiredEventAttributes
        : Option[zio.aws.swf.model.TimerFiredEventAttributes.ReadOnly]
    def timerCanceledEventAttributes
        : Option[zio.aws.swf.model.TimerCanceledEventAttributes.ReadOnly]
    def startChildWorkflowExecutionInitiatedEventAttributes: Option[
      zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes.ReadOnly
    ]
    def childWorkflowExecutionStartedEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionStartedEventAttributes.ReadOnly
    ]
    def childWorkflowExecutionCompletedEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionCompletedEventAttributes.ReadOnly
    ]
    def childWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def childWorkflowExecutionTimedOutEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionTimedOutEventAttributes.ReadOnly
    ]
    def childWorkflowExecutionCanceledEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionCanceledEventAttributes.ReadOnly
    ]
    def childWorkflowExecutionTerminatedEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionTerminatedEventAttributes.ReadOnly
    ]
    def signalExternalWorkflowExecutionInitiatedEventAttributes: Option[
      zio.aws.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly
    ]
    def externalWorkflowExecutionSignaledEventAttributes: Option[
      zio.aws.swf.model.ExternalWorkflowExecutionSignaledEventAttributes.ReadOnly
    ]
    def signalExternalWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def externalWorkflowExecutionCancelRequestedEventAttributes: Option[
      zio.aws.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes.ReadOnly
    ]
    def requestCancelExternalWorkflowExecutionInitiatedEventAttributes: Option[
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly
    ]
    def requestCancelExternalWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def scheduleActivityTaskFailedEventAttributes: Option[
      zio.aws.swf.model.ScheduleActivityTaskFailedEventAttributes.ReadOnly
    ]
    def requestCancelActivityTaskFailedEventAttributes: Option[
      zio.aws.swf.model.RequestCancelActivityTaskFailedEventAttributes.ReadOnly
    ]
    def startTimerFailedEventAttributes
        : Option[zio.aws.swf.model.StartTimerFailedEventAttributes.ReadOnly]
    def cancelTimerFailedEventAttributes
        : Option[zio.aws.swf.model.CancelTimerFailedEventAttributes.ReadOnly]
    def startChildWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.StartChildWorkflowExecutionFailedEventAttributes.ReadOnly
    ]
    def lambdaFunctionScheduledEventAttributes: Option[
      zio.aws.swf.model.LambdaFunctionScheduledEventAttributes.ReadOnly
    ]
    def lambdaFunctionStartedEventAttributes: Option[
      zio.aws.swf.model.LambdaFunctionStartedEventAttributes.ReadOnly
    ]
    def lambdaFunctionCompletedEventAttributes: Option[
      zio.aws.swf.model.LambdaFunctionCompletedEventAttributes.ReadOnly
    ]
    def lambdaFunctionFailedEventAttributes
        : Option[zio.aws.swf.model.LambdaFunctionFailedEventAttributes.ReadOnly]
    def lambdaFunctionTimedOutEventAttributes: Option[
      zio.aws.swf.model.LambdaFunctionTimedOutEventAttributes.ReadOnly
    ]
    def scheduleLambdaFunctionFailedEventAttributes: Option[
      zio.aws.swf.model.ScheduleLambdaFunctionFailedEventAttributes.ReadOnly
    ]
    def startLambdaFunctionFailedEventAttributes: Option[
      zio.aws.swf.model.StartLambdaFunctionFailedEventAttributes.ReadOnly
    ]
    def getEventTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(eventTimestamp)
    def getEventType: ZIO[Any, Nothing, zio.aws.swf.model.EventType] =
      ZIO.succeed(eventType)
    def getEventId: ZIO[Any, Nothing, EventId] = ZIO.succeed(eventId)
    def getWorkflowExecutionStartedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionStartedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionStartedEventAttributes",
      workflowExecutionStartedEventAttributes
    )
    def getWorkflowExecutionCompletedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionCompletedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionCompletedEventAttributes",
      workflowExecutionCompletedEventAttributes
    )
    def getCompleteWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.CompleteWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "completeWorkflowExecutionFailedEventAttributes",
      completeWorkflowExecutionFailedEventAttributes
    )
    def getWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionFailedEventAttributes",
      workflowExecutionFailedEventAttributes
    )
    def getFailWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.FailWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "failWorkflowExecutionFailedEventAttributes",
      failWorkflowExecutionFailedEventAttributes
    )
    def getWorkflowExecutionTimedOutEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionTimedOutEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionTimedOutEventAttributes",
      workflowExecutionTimedOutEventAttributes
    )
    def getWorkflowExecutionCanceledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionCanceledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionCanceledEventAttributes",
      workflowExecutionCanceledEventAttributes
    )
    def getCancelWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.CancelWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cancelWorkflowExecutionFailedEventAttributes",
      cancelWorkflowExecutionFailedEventAttributes
    )
    def getWorkflowExecutionContinuedAsNewEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionContinuedAsNewEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionContinuedAsNewEventAttributes",
      workflowExecutionContinuedAsNewEventAttributes
    )
    def getContinueAsNewWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "continueAsNewWorkflowExecutionFailedEventAttributes",
      continueAsNewWorkflowExecutionFailedEventAttributes
    )
    def getWorkflowExecutionTerminatedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionTerminatedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionTerminatedEventAttributes",
      workflowExecutionTerminatedEventAttributes
    )
    def getWorkflowExecutionCancelRequestedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionCancelRequestedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionCancelRequestedEventAttributes",
      workflowExecutionCancelRequestedEventAttributes
    )
    def getDecisionTaskScheduledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.DecisionTaskScheduledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "decisionTaskScheduledEventAttributes",
      decisionTaskScheduledEventAttributes
    )
    def getDecisionTaskStartedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.DecisionTaskStartedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "decisionTaskStartedEventAttributes",
      decisionTaskStartedEventAttributes
    )
    def getDecisionTaskCompletedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.DecisionTaskCompletedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "decisionTaskCompletedEventAttributes",
      decisionTaskCompletedEventAttributes
    )
    def getDecisionTaskTimedOutEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.DecisionTaskTimedOutEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "decisionTaskTimedOutEventAttributes",
      decisionTaskTimedOutEventAttributes
    )
    def getActivityTaskScheduledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ActivityTaskScheduledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityTaskScheduledEventAttributes",
      activityTaskScheduledEventAttributes
    )
    def getActivityTaskStartedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ActivityTaskStartedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityTaskStartedEventAttributes",
      activityTaskStartedEventAttributes
    )
    def getActivityTaskCompletedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ActivityTaskCompletedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityTaskCompletedEventAttributes",
      activityTaskCompletedEventAttributes
    )
    def getActivityTaskFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ActivityTaskFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityTaskFailedEventAttributes",
      activityTaskFailedEventAttributes
    )
    def getActivityTaskTimedOutEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ActivityTaskTimedOutEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityTaskTimedOutEventAttributes",
      activityTaskTimedOutEventAttributes
    )
    def getActivityTaskCanceledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ActivityTaskCanceledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityTaskCanceledEventAttributes",
      activityTaskCanceledEventAttributes
    )
    def getActivityTaskCancelRequestedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ActivityTaskCancelRequestedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityTaskCancelRequestedEventAttributes",
      activityTaskCancelRequestedEventAttributes
    )
    def getWorkflowExecutionSignaledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionSignaledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowExecutionSignaledEventAttributes",
      workflowExecutionSignaledEventAttributes
    )
    def getMarkerRecordedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.MarkerRecordedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "markerRecordedEventAttributes",
      markerRecordedEventAttributes
    )
    def getRecordMarkerFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.RecordMarkerFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "recordMarkerFailedEventAttributes",
      recordMarkerFailedEventAttributes
    )
    def getTimerStartedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.TimerStartedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "timerStartedEventAttributes",
      timerStartedEventAttributes
    )
    def getTimerFiredEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.TimerFiredEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "timerFiredEventAttributes",
      timerFiredEventAttributes
    )
    def getTimerCanceledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.TimerCanceledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "timerCanceledEventAttributes",
      timerCanceledEventAttributes
    )
    def getStartChildWorkflowExecutionInitiatedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "startChildWorkflowExecutionInitiatedEventAttributes",
      startChildWorkflowExecutionInitiatedEventAttributes
    )
    def getChildWorkflowExecutionStartedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ChildWorkflowExecutionStartedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "childWorkflowExecutionStartedEventAttributes",
      childWorkflowExecutionStartedEventAttributes
    )
    def getChildWorkflowExecutionCompletedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ChildWorkflowExecutionCompletedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "childWorkflowExecutionCompletedEventAttributes",
      childWorkflowExecutionCompletedEventAttributes
    )
    def getChildWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ChildWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "childWorkflowExecutionFailedEventAttributes",
      childWorkflowExecutionFailedEventAttributes
    )
    def getChildWorkflowExecutionTimedOutEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ChildWorkflowExecutionTimedOutEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "childWorkflowExecutionTimedOutEventAttributes",
      childWorkflowExecutionTimedOutEventAttributes
    )
    def getChildWorkflowExecutionCanceledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ChildWorkflowExecutionCanceledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "childWorkflowExecutionCanceledEventAttributes",
      childWorkflowExecutionCanceledEventAttributes
    )
    def getChildWorkflowExecutionTerminatedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ChildWorkflowExecutionTerminatedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "childWorkflowExecutionTerminatedEventAttributes",
      childWorkflowExecutionTerminatedEventAttributes
    )
    def getSignalExternalWorkflowExecutionInitiatedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "signalExternalWorkflowExecutionInitiatedEventAttributes",
      signalExternalWorkflowExecutionInitiatedEventAttributes
    )
    def getExternalWorkflowExecutionSignaledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ExternalWorkflowExecutionSignaledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "externalWorkflowExecutionSignaledEventAttributes",
      externalWorkflowExecutionSignaledEventAttributes
    )
    def getSignalExternalWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "signalExternalWorkflowExecutionFailedEventAttributes",
      signalExternalWorkflowExecutionFailedEventAttributes
    )
    def getExternalWorkflowExecutionCancelRequestedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "externalWorkflowExecutionCancelRequestedEventAttributes",
      externalWorkflowExecutionCancelRequestedEventAttributes
    )
    def getRequestCancelExternalWorkflowExecutionInitiatedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "requestCancelExternalWorkflowExecutionInitiatedEventAttributes",
      requestCancelExternalWorkflowExecutionInitiatedEventAttributes
    )
    def getRequestCancelExternalWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "requestCancelExternalWorkflowExecutionFailedEventAttributes",
      requestCancelExternalWorkflowExecutionFailedEventAttributes
    )
    def getScheduleActivityTaskFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ScheduleActivityTaskFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scheduleActivityTaskFailedEventAttributes",
      scheduleActivityTaskFailedEventAttributes
    )
    def getRequestCancelActivityTaskFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.RequestCancelActivityTaskFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "requestCancelActivityTaskFailedEventAttributes",
      requestCancelActivityTaskFailedEventAttributes
    )
    def getStartTimerFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.StartTimerFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "startTimerFailedEventAttributes",
      startTimerFailedEventAttributes
    )
    def getCancelTimerFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.CancelTimerFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cancelTimerFailedEventAttributes",
      cancelTimerFailedEventAttributes
    )
    def getStartChildWorkflowExecutionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.StartChildWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "startChildWorkflowExecutionFailedEventAttributes",
      startChildWorkflowExecutionFailedEventAttributes
    )
    def getLambdaFunctionScheduledEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.LambdaFunctionScheduledEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionScheduledEventAttributes",
      lambdaFunctionScheduledEventAttributes
    )
    def getLambdaFunctionStartedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.LambdaFunctionStartedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionStartedEventAttributes",
      lambdaFunctionStartedEventAttributes
    )
    def getLambdaFunctionCompletedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.LambdaFunctionCompletedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionCompletedEventAttributes",
      lambdaFunctionCompletedEventAttributes
    )
    def getLambdaFunctionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.LambdaFunctionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionFailedEventAttributes",
      lambdaFunctionFailedEventAttributes
    )
    def getLambdaFunctionTimedOutEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.LambdaFunctionTimedOutEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionTimedOutEventAttributes",
      lambdaFunctionTimedOutEventAttributes
    )
    def getScheduleLambdaFunctionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.ScheduleLambdaFunctionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scheduleLambdaFunctionFailedEventAttributes",
      scheduleLambdaFunctionFailedEventAttributes
    )
    def getStartLambdaFunctionFailedEventAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.StartLambdaFunctionFailedEventAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "startLambdaFunctionFailedEventAttributes",
      startLambdaFunctionFailedEventAttributes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.HistoryEvent
  ) extends zio.aws.swf.model.HistoryEvent.ReadOnly {
    override val eventTimestamp: Timestamp =
      zio.aws.swf.model.primitives.Timestamp(impl.eventTimestamp())
    override val eventType: zio.aws.swf.model.EventType =
      zio.aws.swf.model.EventType.wrap(impl.eventType())
    override val eventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.eventId())
    override val workflowExecutionStartedEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionStartedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.workflowExecutionStartedEventAttributes())
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionStartedEventAttributes.wrap(value)
      )
    override val workflowExecutionCompletedEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionCompletedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.workflowExecutionCompletedEventAttributes())
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionCompletedEventAttributes.wrap(value)
      )
    override val completeWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.CompleteWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.completeWorkflowExecutionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.CompleteWorkflowExecutionFailedEventAttributes
          .wrap(value)
      )
    override val workflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionFailedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.workflowExecutionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionFailedEventAttributes.wrap(value)
      )
    override val failWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.FailWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.failWorkflowExecutionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.FailWorkflowExecutionFailedEventAttributes.wrap(value)
      )
    override val workflowExecutionTimedOutEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionTimedOutEventAttributes.ReadOnly
    ] = scala
      .Option(impl.workflowExecutionTimedOutEventAttributes())
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionTimedOutEventAttributes.wrap(value)
      )
    override val workflowExecutionCanceledEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionCanceledEventAttributes.ReadOnly
    ] = scala
      .Option(impl.workflowExecutionCanceledEventAttributes())
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionCanceledEventAttributes.wrap(value)
      )
    override val cancelWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.CancelWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.cancelWorkflowExecutionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.CancelWorkflowExecutionFailedEventAttributes
          .wrap(value)
      )
    override val workflowExecutionContinuedAsNewEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionContinuedAsNewEventAttributes.ReadOnly
    ] = scala
      .Option(impl.workflowExecutionContinuedAsNewEventAttributes())
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionContinuedAsNewEventAttributes
          .wrap(value)
      )
    override val continueAsNewWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.continueAsNewWorkflowExecutionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes
          .wrap(value)
      )
    override val workflowExecutionTerminatedEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionTerminatedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.workflowExecutionTerminatedEventAttributes())
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionTerminatedEventAttributes.wrap(value)
      )
    override val workflowExecutionCancelRequestedEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionCancelRequestedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.workflowExecutionCancelRequestedEventAttributes())
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionCancelRequestedEventAttributes
          .wrap(value)
      )
    override val decisionTaskScheduledEventAttributes: Option[
      zio.aws.swf.model.DecisionTaskScheduledEventAttributes.ReadOnly
    ] = scala
      .Option(impl.decisionTaskScheduledEventAttributes())
      .map(value =>
        zio.aws.swf.model.DecisionTaskScheduledEventAttributes.wrap(value)
      )
    override val decisionTaskStartedEventAttributes: Option[
      zio.aws.swf.model.DecisionTaskStartedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.decisionTaskStartedEventAttributes())
      .map(value =>
        zio.aws.swf.model.DecisionTaskStartedEventAttributes.wrap(value)
      )
    override val decisionTaskCompletedEventAttributes: Option[
      zio.aws.swf.model.DecisionTaskCompletedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.decisionTaskCompletedEventAttributes())
      .map(value =>
        zio.aws.swf.model.DecisionTaskCompletedEventAttributes.wrap(value)
      )
    override val decisionTaskTimedOutEventAttributes: Option[
      zio.aws.swf.model.DecisionTaskTimedOutEventAttributes.ReadOnly
    ] = scala
      .Option(impl.decisionTaskTimedOutEventAttributes())
      .map(value =>
        zio.aws.swf.model.DecisionTaskTimedOutEventAttributes.wrap(value)
      )
    override val activityTaskScheduledEventAttributes: Option[
      zio.aws.swf.model.ActivityTaskScheduledEventAttributes.ReadOnly
    ] = scala
      .Option(impl.activityTaskScheduledEventAttributes())
      .map(value =>
        zio.aws.swf.model.ActivityTaskScheduledEventAttributes.wrap(value)
      )
    override val activityTaskStartedEventAttributes: Option[
      zio.aws.swf.model.ActivityTaskStartedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.activityTaskStartedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ActivityTaskStartedEventAttributes.wrap(value)
      )
    override val activityTaskCompletedEventAttributes: Option[
      zio.aws.swf.model.ActivityTaskCompletedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.activityTaskCompletedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ActivityTaskCompletedEventAttributes.wrap(value)
      )
    override val activityTaskFailedEventAttributes
        : Option[zio.aws.swf.model.ActivityTaskFailedEventAttributes.ReadOnly] =
      scala
        .Option(impl.activityTaskFailedEventAttributes())
        .map(value =>
          zio.aws.swf.model.ActivityTaskFailedEventAttributes.wrap(value)
        )
    override val activityTaskTimedOutEventAttributes: Option[
      zio.aws.swf.model.ActivityTaskTimedOutEventAttributes.ReadOnly
    ] = scala
      .Option(impl.activityTaskTimedOutEventAttributes())
      .map(value =>
        zio.aws.swf.model.ActivityTaskTimedOutEventAttributes.wrap(value)
      )
    override val activityTaskCanceledEventAttributes: Option[
      zio.aws.swf.model.ActivityTaskCanceledEventAttributes.ReadOnly
    ] = scala
      .Option(impl.activityTaskCanceledEventAttributes())
      .map(value =>
        zio.aws.swf.model.ActivityTaskCanceledEventAttributes.wrap(value)
      )
    override val activityTaskCancelRequestedEventAttributes: Option[
      zio.aws.swf.model.ActivityTaskCancelRequestedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.activityTaskCancelRequestedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ActivityTaskCancelRequestedEventAttributes.wrap(value)
      )
    override val workflowExecutionSignaledEventAttributes: Option[
      zio.aws.swf.model.WorkflowExecutionSignaledEventAttributes.ReadOnly
    ] = scala
      .Option(impl.workflowExecutionSignaledEventAttributes())
      .map(value =>
        zio.aws.swf.model.WorkflowExecutionSignaledEventAttributes.wrap(value)
      )
    override val markerRecordedEventAttributes
        : Option[zio.aws.swf.model.MarkerRecordedEventAttributes.ReadOnly] =
      scala
        .Option(impl.markerRecordedEventAttributes())
        .map(value =>
          zio.aws.swf.model.MarkerRecordedEventAttributes.wrap(value)
        )
    override val recordMarkerFailedEventAttributes
        : Option[zio.aws.swf.model.RecordMarkerFailedEventAttributes.ReadOnly] =
      scala
        .Option(impl.recordMarkerFailedEventAttributes())
        .map(value =>
          zio.aws.swf.model.RecordMarkerFailedEventAttributes.wrap(value)
        )
    override val timerStartedEventAttributes
        : Option[zio.aws.swf.model.TimerStartedEventAttributes.ReadOnly] = scala
      .Option(impl.timerStartedEventAttributes())
      .map(value => zio.aws.swf.model.TimerStartedEventAttributes.wrap(value))
    override val timerFiredEventAttributes
        : Option[zio.aws.swf.model.TimerFiredEventAttributes.ReadOnly] = scala
      .Option(impl.timerFiredEventAttributes())
      .map(value => zio.aws.swf.model.TimerFiredEventAttributes.wrap(value))
    override val timerCanceledEventAttributes
        : Option[zio.aws.swf.model.TimerCanceledEventAttributes.ReadOnly] =
      scala
        .Option(impl.timerCanceledEventAttributes())
        .map(value =>
          zio.aws.swf.model.TimerCanceledEventAttributes.wrap(value)
        )
    override val startChildWorkflowExecutionInitiatedEventAttributes: Option[
      zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.startChildWorkflowExecutionInitiatedEventAttributes())
      .map(value =>
        zio.aws.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes
          .wrap(value)
      )
    override val childWorkflowExecutionStartedEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionStartedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.childWorkflowExecutionStartedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ChildWorkflowExecutionStartedEventAttributes
          .wrap(value)
      )
    override val childWorkflowExecutionCompletedEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionCompletedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.childWorkflowExecutionCompletedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ChildWorkflowExecutionCompletedEventAttributes
          .wrap(value)
      )
    override val childWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.childWorkflowExecutionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ChildWorkflowExecutionFailedEventAttributes
          .wrap(value)
      )
    override val childWorkflowExecutionTimedOutEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionTimedOutEventAttributes.ReadOnly
    ] = scala
      .Option(impl.childWorkflowExecutionTimedOutEventAttributes())
      .map(value =>
        zio.aws.swf.model.ChildWorkflowExecutionTimedOutEventAttributes
          .wrap(value)
      )
    override val childWorkflowExecutionCanceledEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionCanceledEventAttributes.ReadOnly
    ] = scala
      .Option(impl.childWorkflowExecutionCanceledEventAttributes())
      .map(value =>
        zio.aws.swf.model.ChildWorkflowExecutionCanceledEventAttributes
          .wrap(value)
      )
    override val childWorkflowExecutionTerminatedEventAttributes: Option[
      zio.aws.swf.model.ChildWorkflowExecutionTerminatedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.childWorkflowExecutionTerminatedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ChildWorkflowExecutionTerminatedEventAttributes
          .wrap(value)
      )
    override val signalExternalWorkflowExecutionInitiatedEventAttributes: Option[
      zio.aws.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.signalExternalWorkflowExecutionInitiatedEventAttributes())
      .map(value =>
        zio.aws.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes
          .wrap(value)
      )
    override val externalWorkflowExecutionSignaledEventAttributes: Option[
      zio.aws.swf.model.ExternalWorkflowExecutionSignaledEventAttributes.ReadOnly
    ] = scala
      .Option(impl.externalWorkflowExecutionSignaledEventAttributes())
      .map(value =>
        zio.aws.swf.model.ExternalWorkflowExecutionSignaledEventAttributes
          .wrap(value)
      )
    override val signalExternalWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.signalExternalWorkflowExecutionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes
          .wrap(value)
      )
    override val externalWorkflowExecutionCancelRequestedEventAttributes: Option[
      zio.aws.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.externalWorkflowExecutionCancelRequestedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes
          .wrap(value)
      )
    override val requestCancelExternalWorkflowExecutionInitiatedEventAttributes
        : Option[
          zio.aws.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly
        ] = scala
      .Option(
        impl.requestCancelExternalWorkflowExecutionInitiatedEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
          .wrap(value)
      )
    override val requestCancelExternalWorkflowExecutionFailedEventAttributes
        : Option[
          zio.aws.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes.ReadOnly
        ] = scala
      .Option(
        impl.requestCancelExternalWorkflowExecutionFailedEventAttributes()
      )
      .map(value =>
        zio.aws.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes
          .wrap(value)
      )
    override val scheduleActivityTaskFailedEventAttributes: Option[
      zio.aws.swf.model.ScheduleActivityTaskFailedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.scheduleActivityTaskFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ScheduleActivityTaskFailedEventAttributes.wrap(value)
      )
    override val requestCancelActivityTaskFailedEventAttributes: Option[
      zio.aws.swf.model.RequestCancelActivityTaskFailedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.requestCancelActivityTaskFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.RequestCancelActivityTaskFailedEventAttributes
          .wrap(value)
      )
    override val startTimerFailedEventAttributes
        : Option[zio.aws.swf.model.StartTimerFailedEventAttributes.ReadOnly] =
      scala
        .Option(impl.startTimerFailedEventAttributes())
        .map(value =>
          zio.aws.swf.model.StartTimerFailedEventAttributes.wrap(value)
        )
    override val cancelTimerFailedEventAttributes
        : Option[zio.aws.swf.model.CancelTimerFailedEventAttributes.ReadOnly] =
      scala
        .Option(impl.cancelTimerFailedEventAttributes())
        .map(value =>
          zio.aws.swf.model.CancelTimerFailedEventAttributes.wrap(value)
        )
    override val startChildWorkflowExecutionFailedEventAttributes: Option[
      zio.aws.swf.model.StartChildWorkflowExecutionFailedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.startChildWorkflowExecutionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.StartChildWorkflowExecutionFailedEventAttributes
          .wrap(value)
      )
    override val lambdaFunctionScheduledEventAttributes: Option[
      zio.aws.swf.model.LambdaFunctionScheduledEventAttributes.ReadOnly
    ] = scala
      .Option(impl.lambdaFunctionScheduledEventAttributes())
      .map(value =>
        zio.aws.swf.model.LambdaFunctionScheduledEventAttributes.wrap(value)
      )
    override val lambdaFunctionStartedEventAttributes: Option[
      zio.aws.swf.model.LambdaFunctionStartedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.lambdaFunctionStartedEventAttributes())
      .map(value =>
        zio.aws.swf.model.LambdaFunctionStartedEventAttributes.wrap(value)
      )
    override val lambdaFunctionCompletedEventAttributes: Option[
      zio.aws.swf.model.LambdaFunctionCompletedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.lambdaFunctionCompletedEventAttributes())
      .map(value =>
        zio.aws.swf.model.LambdaFunctionCompletedEventAttributes.wrap(value)
      )
    override val lambdaFunctionFailedEventAttributes: Option[
      zio.aws.swf.model.LambdaFunctionFailedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.lambdaFunctionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.LambdaFunctionFailedEventAttributes.wrap(value)
      )
    override val lambdaFunctionTimedOutEventAttributes: Option[
      zio.aws.swf.model.LambdaFunctionTimedOutEventAttributes.ReadOnly
    ] = scala
      .Option(impl.lambdaFunctionTimedOutEventAttributes())
      .map(value =>
        zio.aws.swf.model.LambdaFunctionTimedOutEventAttributes.wrap(value)
      )
    override val scheduleLambdaFunctionFailedEventAttributes: Option[
      zio.aws.swf.model.ScheduleLambdaFunctionFailedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.scheduleLambdaFunctionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.ScheduleLambdaFunctionFailedEventAttributes
          .wrap(value)
      )
    override val startLambdaFunctionFailedEventAttributes: Option[
      zio.aws.swf.model.StartLambdaFunctionFailedEventAttributes.ReadOnly
    ] = scala
      .Option(impl.startLambdaFunctionFailedEventAttributes())
      .map(value =>
        zio.aws.swf.model.StartLambdaFunctionFailedEventAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.HistoryEvent
  ): zio.aws.swf.model.HistoryEvent.ReadOnly = new Wrapper(impl)
}
