package zio.aws.supportapp.model
import zio.ZIO
import zio.aws.supportapp.model.primitives.{
  RoleArn,
  TeamId,
  ChannelName,
  ChannelId,
  BooleanValue
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSlackChannelConfigurationResponse(
    channelId: Optional[ChannelId] = Optional.Absent,
    channelName: Optional[ChannelName] = Optional.Absent,
    channelRoleArn: Optional[RoleArn] = Optional.Absent,
    notifyOnAddCorrespondenceToCase: Optional[BooleanValue] = Optional.Absent,
    notifyOnCaseSeverity: Optional[
      zio.aws.supportapp.model.NotificationSeverityLevel
    ] = Optional.Absent,
    notifyOnCreateOrReopenCase: Optional[BooleanValue] = Optional.Absent,
    notifyOnResolveCase: Optional[BooleanValue] = Optional.Absent,
    teamId: Optional[TeamId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.supportapp.model.UpdateSlackChannelConfigurationResponse = {
    import UpdateSlackChannelConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.supportapp.model.UpdateSlackChannelConfigurationResponse
      .builder()
      .optionallyWith(
        channelId.map(value => ChannelId.unwrap(value): java.lang.String)
      )(_.channelId)
      .optionallyWith(
        channelName.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.channelName)
      .optionallyWith(
        channelRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.channelRoleArn)
      .optionallyWith(
        notifyOnAddCorrespondenceToCase.map(value => value: java.lang.Boolean)
      )(_.notifyOnAddCorrespondenceToCase)
      .optionallyWith(notifyOnCaseSeverity.map(value => value.unwrap))(
        _.notifyOnCaseSeverity
      )
      .optionallyWith(
        notifyOnCreateOrReopenCase.map(value => value: java.lang.Boolean)
      )(_.notifyOnCreateOrReopenCase)
      .optionallyWith(
        notifyOnResolveCase.map(value => value: java.lang.Boolean)
      )(_.notifyOnResolveCase)
      .optionallyWith(
        teamId.map(value => TeamId.unwrap(value): java.lang.String)
      )(_.teamId)
      .build()
  }
  def asReadOnly
      : zio.aws.supportapp.model.UpdateSlackChannelConfigurationResponse.ReadOnly =
    zio.aws.supportapp.model.UpdateSlackChannelConfigurationResponse
      .wrap(buildAwsValue())
}
object UpdateSlackChannelConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.supportapp.model.UpdateSlackChannelConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.supportapp.model.UpdateSlackChannelConfigurationResponse =
      zio.aws.supportapp.model.UpdateSlackChannelConfigurationResponse(
        channelId.map(value => value),
        channelName.map(value => value),
        channelRoleArn.map(value => value),
        notifyOnAddCorrespondenceToCase.map(value => value),
        notifyOnCaseSeverity.map(value => value),
        notifyOnCreateOrReopenCase.map(value => value),
        notifyOnResolveCase.map(value => value),
        teamId.map(value => value)
      )
    def channelId: Optional[ChannelId]
    def channelName: Optional[ChannelName]
    def channelRoleArn: Optional[RoleArn]
    def notifyOnAddCorrespondenceToCase: Optional[BooleanValue]
    def notifyOnCaseSeverity
        : Optional[zio.aws.supportapp.model.NotificationSeverityLevel]
    def notifyOnCreateOrReopenCase: Optional[BooleanValue]
    def notifyOnResolveCase: Optional[BooleanValue]
    def teamId: Optional[TeamId]
    def getChannelId: ZIO[Any, AwsError, ChannelId] =
      AwsError.unwrapOptionField("channelId", channelId)
    def getChannelName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("channelName", channelName)
    def getChannelRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("channelRoleArn", channelRoleArn)
    def getNotifyOnAddCorrespondenceToCase: ZIO[Any, AwsError, BooleanValue] =
      AwsError.unwrapOptionField(
        "notifyOnAddCorrespondenceToCase",
        notifyOnAddCorrespondenceToCase
      )
    def getNotifyOnCaseSeverity: ZIO[
      Any,
      AwsError,
      zio.aws.supportapp.model.NotificationSeverityLevel
    ] = AwsError.unwrapOptionField("notifyOnCaseSeverity", notifyOnCaseSeverity)
    def getNotifyOnCreateOrReopenCase: ZIO[Any, AwsError, BooleanValue] =
      AwsError.unwrapOptionField(
        "notifyOnCreateOrReopenCase",
        notifyOnCreateOrReopenCase
      )
    def getNotifyOnResolveCase: ZIO[Any, AwsError, BooleanValue] =
      AwsError.unwrapOptionField("notifyOnResolveCase", notifyOnResolveCase)
    def getTeamId: ZIO[Any, AwsError, TeamId] =
      AwsError.unwrapOptionField("teamId", teamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.supportapp.model.UpdateSlackChannelConfigurationResponse
  ) extends zio.aws.supportapp.model.UpdateSlackChannelConfigurationResponse.ReadOnly {
    override val channelId: Optional[ChannelId] = zio.aws.core.internal
      .optionalFromNullable(impl.channelId())
      .map(value => zio.aws.supportapp.model.primitives.ChannelId(value))
    override val channelName: Optional[ChannelName] = zio.aws.core.internal
      .optionalFromNullable(impl.channelName())
      .map(value => zio.aws.supportapp.model.primitives.ChannelName(value))
    override val channelRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelRoleArn())
      .map(value => zio.aws.supportapp.model.primitives.RoleArn(value))
    override val notifyOnAddCorrespondenceToCase: Optional[BooleanValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifyOnAddCorrespondenceToCase())
        .map(value => value: BooleanValue)
    override val notifyOnCaseSeverity
        : Optional[zio.aws.supportapp.model.NotificationSeverityLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifyOnCaseSeverity())
        .map(value =>
          zio.aws.supportapp.model.NotificationSeverityLevel.wrap(value)
        )
    override val notifyOnCreateOrReopenCase: Optional[BooleanValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifyOnCreateOrReopenCase())
        .map(value => value: BooleanValue)
    override val notifyOnResolveCase: Optional[BooleanValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifyOnResolveCase())
        .map(value => value: BooleanValue)
    override val teamId: Optional[TeamId] = zio.aws.core.internal
      .optionalFromNullable(impl.teamId())
      .map(value => zio.aws.supportapp.model.primitives.TeamId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.supportapp.model.UpdateSlackChannelConfigurationResponse
  ): zio.aws.supportapp.model.UpdateSlackChannelConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
