package zio.aws.supportapp
import zio.aws.supportapp.model.PutAccountAliasResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.supportapp.model.{
  DeleteSlackWorkspaceConfigurationRequest,
  UpdateSlackChannelConfigurationRequest,
  RegisterSlackWorkspaceForOrganizationRequest,
  PutAccountAliasRequest,
  CreateSlackChannelConfigurationRequest,
  ListSlackWorkspaceConfigurationsRequest,
  GetAccountAliasRequest,
  ListSlackChannelConfigurationsRequest,
  DeleteSlackChannelConfigurationRequest,
  DeleteAccountAliasRequest
}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.supportapp.SupportAppAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
object SupportAppMock extends Mock[SupportApp] {
  object DeleteAccountAlias
      extends Effect[
        DeleteAccountAliasRequest,
        AwsError,
        zio.aws.supportapp.model.DeleteAccountAliasResponse.ReadOnly
      ]
  object DeleteSlackChannelConfiguration
      extends Effect[
        DeleteSlackChannelConfigurationRequest,
        AwsError,
        zio.aws.supportapp.model.DeleteSlackChannelConfigurationResponse.ReadOnly
      ]
  object ListSlackWorkspaceConfigurations
      extends Effect[
        ListSlackWorkspaceConfigurationsRequest,
        AwsError,
        zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsResponse.ReadOnly
      ]
  object UpdateSlackChannelConfiguration
      extends Effect[
        UpdateSlackChannelConfigurationRequest,
        AwsError,
        zio.aws.supportapp.model.UpdateSlackChannelConfigurationResponse.ReadOnly
      ]
  object RegisterSlackWorkspaceForOrganization
      extends Effect[
        RegisterSlackWorkspaceForOrganizationRequest,
        AwsError,
        zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse.ReadOnly
      ]
  object DeleteSlackWorkspaceConfiguration
      extends Effect[
        DeleteSlackWorkspaceConfigurationRequest,
        AwsError,
        zio.aws.supportapp.model.DeleteSlackWorkspaceConfigurationResponse.ReadOnly
      ]
  object PutAccountAlias
      extends Effect[PutAccountAliasRequest, AwsError, ReadOnly]
  object CreateSlackChannelConfiguration
      extends Effect[
        CreateSlackChannelConfigurationRequest,
        AwsError,
        zio.aws.supportapp.model.CreateSlackChannelConfigurationResponse.ReadOnly
      ]
  object ListSlackChannelConfigurations
      extends Effect[
        ListSlackChannelConfigurationsRequest,
        AwsError,
        zio.aws.supportapp.model.ListSlackChannelConfigurationsResponse.ReadOnly
      ]
  object GetAccountAlias
      extends Effect[
        GetAccountAliasRequest,
        AwsError,
        zio.aws.supportapp.model.GetAccountAliasResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, SupportApp] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, SupportApp] { rts =>
        zio.ZIO.succeed {
          new SupportApp {
            val api: SupportAppAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): SupportApp = this
            def deleteAccountAlias(request: DeleteAccountAliasRequest): IO[
              AwsError,
              zio.aws.supportapp.model.DeleteAccountAliasResponse.ReadOnly
            ] = proxy(DeleteAccountAlias, request)
            def deleteSlackChannelConfiguration(
                request: DeleteSlackChannelConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.supportapp.model.DeleteSlackChannelConfigurationResponse.ReadOnly
            ] = proxy(DeleteSlackChannelConfiguration, request)
            def listSlackWorkspaceConfigurations(
                request: ListSlackWorkspaceConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsResponse.ReadOnly
            ] = proxy(ListSlackWorkspaceConfigurations, request)
            def updateSlackChannelConfiguration(
                request: UpdateSlackChannelConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.supportapp.model.UpdateSlackChannelConfigurationResponse.ReadOnly
            ] = proxy(UpdateSlackChannelConfiguration, request)
            def registerSlackWorkspaceForOrganization(
                request: RegisterSlackWorkspaceForOrganizationRequest
            ): IO[
              AwsError,
              zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse.ReadOnly
            ] = proxy(RegisterSlackWorkspaceForOrganization, request)
            def deleteSlackWorkspaceConfiguration(
                request: DeleteSlackWorkspaceConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.supportapp.model.DeleteSlackWorkspaceConfigurationResponse.ReadOnly
            ] = proxy(DeleteSlackWorkspaceConfiguration, request)
            def putAccountAlias(
                request: PutAccountAliasRequest
            ): IO[AwsError, ReadOnly] = proxy(PutAccountAlias, request)
            def createSlackChannelConfiguration(
                request: CreateSlackChannelConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.supportapp.model.CreateSlackChannelConfigurationResponse.ReadOnly
            ] = proxy(CreateSlackChannelConfiguration, request)
            def listSlackChannelConfigurations(
                request: ListSlackChannelConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.supportapp.model.ListSlackChannelConfigurationsResponse.ReadOnly
            ] = proxy(ListSlackChannelConfigurations, request)
            def getAccountAlias(request: GetAccountAliasRequest): IO[
              AwsError,
              zio.aws.supportapp.model.GetAccountAliasResponse.ReadOnly
            ] = proxy(GetAccountAlias, request)
          }
        }
      }
    }
  }
}
