package zio.aws.supportapp.model
import zio.ZIO
import zio.aws.supportapp.model.primitives.AwsAccountAlias
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAccountAliasResponse(
    accountAlias: Optional[AwsAccountAlias] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.supportapp.model.GetAccountAliasResponse = {
    import GetAccountAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.supportapp.model.GetAccountAliasResponse
      .builder()
      .optionallyWith(
        accountAlias.map(value =>
          AwsAccountAlias.unwrap(value): java.lang.String
        )
      )(_.accountAlias)
      .build()
  }
  def asReadOnly: zio.aws.supportapp.model.GetAccountAliasResponse.ReadOnly =
    zio.aws.supportapp.model.GetAccountAliasResponse.wrap(buildAwsValue())
}
object GetAccountAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.supportapp.model.GetAccountAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.supportapp.model.GetAccountAliasResponse =
      zio.aws.supportapp.model
        .GetAccountAliasResponse(accountAlias.map(value => value))
    def accountAlias: Optional[AwsAccountAlias]
    def getAccountAlias: ZIO[Any, AwsError, AwsAccountAlias] =
      AwsError.unwrapOptionField("accountAlias", accountAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.supportapp.model.GetAccountAliasResponse
  ) extends zio.aws.supportapp.model.GetAccountAliasResponse.ReadOnly {
    override val accountAlias: Optional[AwsAccountAlias] = zio.aws.core.internal
      .optionalFromNullable(impl.accountAlias())
      .map(value => zio.aws.supportapp.model.primitives.AwsAccountAlias(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.supportapp.model.GetAccountAliasResponse
  ): zio.aws.supportapp.model.GetAccountAliasResponse.ReadOnly = new Wrapper(
    impl
  )
}
