package zio.aws.supportapp.model
import zio.ZIO
import zio.aws.supportapp.model.primitives.{
  RoleArn,
  TeamId,
  ChannelName,
  ChannelId,
  BooleanValue
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSlackChannelConfigurationRequest(
    channelId: ChannelId,
    channelName: Optional[ChannelName] = Optional.Absent,
    channelRoleArn: RoleArn,
    notifyOnAddCorrespondenceToCase: Optional[BooleanValue] = Optional.Absent,
    notifyOnCaseSeverity: zio.aws.supportapp.model.NotificationSeverityLevel,
    notifyOnCreateOrReopenCase: Optional[BooleanValue] = Optional.Absent,
    notifyOnResolveCase: Optional[BooleanValue] = Optional.Absent,
    teamId: TeamId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.supportapp.model.CreateSlackChannelConfigurationRequest = {
    import CreateSlackChannelConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.supportapp.model.CreateSlackChannelConfigurationRequest
      .builder()
      .channelId(ChannelId.unwrap(channelId): java.lang.String)
      .optionallyWith(
        channelName.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.channelName)
      .channelRoleArn(RoleArn.unwrap(channelRoleArn): java.lang.String)
      .optionallyWith(
        notifyOnAddCorrespondenceToCase.map(value => value: java.lang.Boolean)
      )(_.notifyOnAddCorrespondenceToCase)
      .notifyOnCaseSeverity(notifyOnCaseSeverity.unwrap)
      .optionallyWith(
        notifyOnCreateOrReopenCase.map(value => value: java.lang.Boolean)
      )(_.notifyOnCreateOrReopenCase)
      .optionallyWith(
        notifyOnResolveCase.map(value => value: java.lang.Boolean)
      )(_.notifyOnResolveCase)
      .teamId(TeamId.unwrap(teamId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.supportapp.model.CreateSlackChannelConfigurationRequest.ReadOnly =
    zio.aws.supportapp.model.CreateSlackChannelConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateSlackChannelConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.supportapp.model.CreateSlackChannelConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.supportapp.model.CreateSlackChannelConfigurationRequest =
      zio.aws.supportapp.model.CreateSlackChannelConfigurationRequest(
        channelId,
        channelName.map(value => value),
        channelRoleArn,
        notifyOnAddCorrespondenceToCase.map(value => value),
        notifyOnCaseSeverity,
        notifyOnCreateOrReopenCase.map(value => value),
        notifyOnResolveCase.map(value => value),
        teamId
      )
    def channelId: ChannelId
    def channelName: Optional[ChannelName]
    def channelRoleArn: RoleArn
    def notifyOnAddCorrespondenceToCase: Optional[BooleanValue]
    def notifyOnCaseSeverity: zio.aws.supportapp.model.NotificationSeverityLevel
    def notifyOnCreateOrReopenCase: Optional[BooleanValue]
    def notifyOnResolveCase: Optional[BooleanValue]
    def teamId: TeamId
    def getChannelId: ZIO[Any, Nothing, ChannelId] = ZIO.succeed(channelId)
    def getChannelName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("channelName", channelName)
    def getChannelRoleArn: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(channelRoleArn)
    def getNotifyOnAddCorrespondenceToCase: ZIO[Any, AwsError, BooleanValue] =
      AwsError.unwrapOptionField(
        "notifyOnAddCorrespondenceToCase",
        notifyOnAddCorrespondenceToCase
      )
    def getNotifyOnCaseSeverity: ZIO[
      Any,
      Nothing,
      zio.aws.supportapp.model.NotificationSeverityLevel
    ] = ZIO.succeed(notifyOnCaseSeverity)
    def getNotifyOnCreateOrReopenCase: ZIO[Any, AwsError, BooleanValue] =
      AwsError.unwrapOptionField(
        "notifyOnCreateOrReopenCase",
        notifyOnCreateOrReopenCase
      )
    def getNotifyOnResolveCase: ZIO[Any, AwsError, BooleanValue] =
      AwsError.unwrapOptionField("notifyOnResolveCase", notifyOnResolveCase)
    def getTeamId: ZIO[Any, Nothing, TeamId] = ZIO.succeed(teamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.supportapp.model.CreateSlackChannelConfigurationRequest
  ) extends zio.aws.supportapp.model.CreateSlackChannelConfigurationRequest.ReadOnly {
    override val channelId: ChannelId =
      zio.aws.supportapp.model.primitives.ChannelId(impl.channelId())
    override val channelName: Optional[ChannelName] = zio.aws.core.internal
      .optionalFromNullable(impl.channelName())
      .map(value => zio.aws.supportapp.model.primitives.ChannelName(value))
    override val channelRoleArn: RoleArn =
      zio.aws.supportapp.model.primitives.RoleArn(impl.channelRoleArn())
    override val notifyOnAddCorrespondenceToCase: Optional[BooleanValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifyOnAddCorrespondenceToCase())
        .map(value => value: BooleanValue)
    override val notifyOnCaseSeverity
        : zio.aws.supportapp.model.NotificationSeverityLevel =
      zio.aws.supportapp.model.NotificationSeverityLevel
        .wrap(impl.notifyOnCaseSeverity())
    override val notifyOnCreateOrReopenCase: Optional[BooleanValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifyOnCreateOrReopenCase())
        .map(value => value: BooleanValue)
    override val notifyOnResolveCase: Optional[BooleanValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifyOnResolveCase())
        .map(value => value: BooleanValue)
    override val teamId: TeamId =
      zio.aws.supportapp.model.primitives.TeamId(impl.teamId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.supportapp.model.CreateSlackChannelConfigurationRequest
  ): zio.aws.supportapp.model.CreateSlackChannelConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
