package zio.aws.supportapp
import software.amazon.awssdk.services.supportapp.model.{
  RegisterSlackWorkspaceForOrganizationResponse,
  DeleteSlackWorkspaceConfigurationRequest,
  UpdateSlackChannelConfigurationRequest,
  ListSlackWorkspaceConfigurationsResponse,
  DeleteSlackChannelConfigurationResponse,
  RegisterSlackWorkspaceForOrganizationRequest,
  PutAccountAliasRequest,
  CreateSlackChannelConfigurationRequest,
  ListSlackWorkspaceConfigurationsRequest,
  GetAccountAliasRequest,
  UpdateSlackChannelConfigurationResponse,
  DeleteAccountAliasResponse,
  DeleteSlackWorkspaceConfigurationResponse,
  ListSlackChannelConfigurationsRequest,
  PutAccountAliasResponse,
  CreateSlackChannelConfigurationResponse,
  DeleteSlackChannelConfigurationRequest,
  ListSlackChannelConfigurationsResponse,
  DeleteAccountAliasRequest,
  GetAccountAliasResponse
}
import zio.aws.supportapp.model.PutAccountAliasResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.supportapp.{
  SupportAppAsyncClientBuilder,
  SupportAppAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import scala.jdk.CollectionConverters.*
trait SupportApp extends AspectSupport[SupportApp] {
  val api: SupportAppAsyncClient
  def deleteAccountAlias(
      request: zio.aws.supportapp.model.DeleteAccountAliasRequest
  ): IO[AwsError, zio.aws.supportapp.model.DeleteAccountAliasResponse.ReadOnly]
  def deleteSlackChannelConfiguration(
      request: zio.aws.supportapp.model.DeleteSlackChannelConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.supportapp.model.DeleteSlackChannelConfigurationResponse.ReadOnly
  ]
  def listSlackWorkspaceConfigurations(
      request: zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsResponse.ReadOnly
  ]
  def updateSlackChannelConfiguration(
      request: zio.aws.supportapp.model.UpdateSlackChannelConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.supportapp.model.UpdateSlackChannelConfigurationResponse.ReadOnly
  ]
  def registerSlackWorkspaceForOrganization(
      request: zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest
  ): IO[
    AwsError,
    zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse.ReadOnly
  ]
  def deleteSlackWorkspaceConfiguration(
      request: zio.aws.supportapp.model.DeleteSlackWorkspaceConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.supportapp.model.DeleteSlackWorkspaceConfigurationResponse.ReadOnly
  ]
  def putAccountAlias(
      request: zio.aws.supportapp.model.PutAccountAliasRequest
  ): IO[AwsError, ReadOnly]
  def createSlackChannelConfiguration(
      request: zio.aws.supportapp.model.CreateSlackChannelConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.supportapp.model.CreateSlackChannelConfigurationResponse.ReadOnly
  ]
  def listSlackChannelConfigurations(
      request: zio.aws.supportapp.model.ListSlackChannelConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.supportapp.model.ListSlackChannelConfigurationsResponse.ReadOnly
  ]
  def getAccountAlias(
      request: zio.aws.supportapp.model.GetAccountAliasRequest
  ): IO[AwsError, zio.aws.supportapp.model.GetAccountAliasResponse.ReadOnly]
}
object SupportApp {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SupportApp] = customized(
    identity
  )
  def customized(
      customization: SupportAppAsyncClientBuilder => SupportAppAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SupportApp] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SupportAppAsyncClientBuilder => SupportAppAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, SupportApp] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SupportAppAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SupportAppAsyncClient, SupportAppAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[SupportAppAsyncClient, SupportAppAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new SupportAppImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SupportAppImpl[R](
      override val api: SupportAppAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SupportApp
      with AwsServiceBase[R] {
    override val serviceName: String = "SupportApp"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SupportAppImpl[R1] = new SupportAppImpl(api, newAspect, r)
    def deleteAccountAlias(
        request: zio.aws.supportapp.model.DeleteAccountAliasRequest
    ): IO[
      AwsError,
      zio.aws.supportapp.model.DeleteAccountAliasResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteAccountAliasRequest,
      DeleteAccountAliasResponse
    ]("deleteAccountAlias", api.deleteAccountAlias)(request.buildAwsValue())
      .map(zio.aws.supportapp.model.DeleteAccountAliasResponse.wrap)
      .provideEnvironment(r)
    def deleteSlackChannelConfiguration(
        request: zio.aws.supportapp.model.DeleteSlackChannelConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.supportapp.model.DeleteSlackChannelConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteSlackChannelConfigurationRequest,
      DeleteSlackChannelConfigurationResponse
    ]("deleteSlackChannelConfiguration", api.deleteSlackChannelConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.supportapp.model.DeleteSlackChannelConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listSlackWorkspaceConfigurations(
        request: zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSlackWorkspaceConfigurationsRequest,
      ListSlackWorkspaceConfigurationsResponse
    ]("listSlackWorkspaceConfigurations", api.listSlackWorkspaceConfigurations)(
      request.buildAwsValue()
    ).map(
      zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsResponse.wrap
    ).provideEnvironment(r)
    def updateSlackChannelConfiguration(
        request: zio.aws.supportapp.model.UpdateSlackChannelConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.supportapp.model.UpdateSlackChannelConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSlackChannelConfigurationRequest,
      UpdateSlackChannelConfigurationResponse
    ]("updateSlackChannelConfiguration", api.updateSlackChannelConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.supportapp.model.UpdateSlackChannelConfigurationResponse.wrap)
      .provideEnvironment(r)
    def registerSlackWorkspaceForOrganization(
        request: zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest
    ): IO[
      AwsError,
      zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse.ReadOnly
    ] = asyncRequestResponse[
      RegisterSlackWorkspaceForOrganizationRequest,
      RegisterSlackWorkspaceForOrganizationResponse
    ](
      "registerSlackWorkspaceForOrganization",
      api.registerSlackWorkspaceForOrganization
    )(request.buildAwsValue())
      .map(
        zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse.wrap
      )
      .provideEnvironment(r)
    def deleteSlackWorkspaceConfiguration(
        request: zio.aws.supportapp.model.DeleteSlackWorkspaceConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.supportapp.model.DeleteSlackWorkspaceConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteSlackWorkspaceConfigurationRequest,
      DeleteSlackWorkspaceConfigurationResponse
    ](
      "deleteSlackWorkspaceConfiguration",
      api.deleteSlackWorkspaceConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.supportapp.model.DeleteSlackWorkspaceConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def putAccountAlias(
        request: zio.aws.supportapp.model.PutAccountAliasRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[PutAccountAliasRequest, PutAccountAliasResponse](
        "putAccountAlias",
        api.putAccountAlias
      )(request.buildAwsValue())
        .map(zio.aws.supportapp.model.PutAccountAliasResponse.wrap)
        .provideEnvironment(r)
    def createSlackChannelConfiguration(
        request: zio.aws.supportapp.model.CreateSlackChannelConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.supportapp.model.CreateSlackChannelConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateSlackChannelConfigurationRequest,
      CreateSlackChannelConfigurationResponse
    ]("createSlackChannelConfiguration", api.createSlackChannelConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.supportapp.model.CreateSlackChannelConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listSlackChannelConfigurations(
        request: zio.aws.supportapp.model.ListSlackChannelConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.supportapp.model.ListSlackChannelConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSlackChannelConfigurationsRequest,
      ListSlackChannelConfigurationsResponse
    ]("listSlackChannelConfigurations", api.listSlackChannelConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.supportapp.model.ListSlackChannelConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def getAccountAlias(
        request: zio.aws.supportapp.model.GetAccountAliasRequest
    ): IO[AwsError, zio.aws.supportapp.model.GetAccountAliasResponse.ReadOnly] =
      asyncRequestResponse[GetAccountAliasRequest, GetAccountAliasResponse](
        "getAccountAlias",
        api.getAccountAlias
      )(request.buildAwsValue())
        .map(zio.aws.supportapp.model.GetAccountAliasResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteAccountAlias(
      request: zio.aws.supportapp.model.DeleteAccountAliasRequest
  ): ZIO[
    zio.aws.supportapp.SupportApp,
    AwsError,
    zio.aws.supportapp.model.DeleteAccountAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAccountAlias(request))
  def deleteSlackChannelConfiguration(
      request: zio.aws.supportapp.model.DeleteSlackChannelConfigurationRequest
  ): ZIO[
    zio.aws.supportapp.SupportApp,
    AwsError,
    zio.aws.supportapp.model.DeleteSlackChannelConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSlackChannelConfiguration(request))
  def listSlackWorkspaceConfigurations(
      request: zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsRequest
  ): ZIO[
    zio.aws.supportapp.SupportApp,
    AwsError,
    zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSlackWorkspaceConfigurations(request))
  def updateSlackChannelConfiguration(
      request: zio.aws.supportapp.model.UpdateSlackChannelConfigurationRequest
  ): ZIO[
    zio.aws.supportapp.SupportApp,
    AwsError,
    zio.aws.supportapp.model.UpdateSlackChannelConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSlackChannelConfiguration(request))
  def registerSlackWorkspaceForOrganization(
      request: zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest
  ): ZIO[
    zio.aws.supportapp.SupportApp,
    AwsError,
    zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerSlackWorkspaceForOrganization(request))
  def deleteSlackWorkspaceConfiguration(
      request: zio.aws.supportapp.model.DeleteSlackWorkspaceConfigurationRequest
  ): ZIO[
    zio.aws.supportapp.SupportApp,
    AwsError,
    zio.aws.supportapp.model.DeleteSlackWorkspaceConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSlackWorkspaceConfiguration(request))
  def putAccountAlias(
      request: zio.aws.supportapp.model.PutAccountAliasRequest
  ): ZIO[zio.aws.supportapp.SupportApp, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.putAccountAlias(request))
  def createSlackChannelConfiguration(
      request: zio.aws.supportapp.model.CreateSlackChannelConfigurationRequest
  ): ZIO[
    zio.aws.supportapp.SupportApp,
    AwsError,
    zio.aws.supportapp.model.CreateSlackChannelConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSlackChannelConfiguration(request))
  def listSlackChannelConfigurations(
      request: zio.aws.supportapp.model.ListSlackChannelConfigurationsRequest
  ): ZIO[
    zio.aws.supportapp.SupportApp,
    AwsError,
    zio.aws.supportapp.model.ListSlackChannelConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSlackChannelConfigurations(request))
  def getAccountAlias(
      request: zio.aws.supportapp.model.GetAccountAliasRequest
  ): ZIO[
    zio.aws.supportapp.SupportApp,
    AwsError,
    zio.aws.supportapp.model.GetAccountAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccountAlias(request))
}
