package zio.aws.supportapp.model
import zio.ZIO
import zio.aws.supportapp.model.primitives.{TeamName, TeamId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RegisterSlackWorkspaceForOrganizationResponse(
    accountType: Optional[zio.aws.supportapp.model.AccountType] =
      Optional.Absent,
    teamId: Optional[TeamId] = Optional.Absent,
    teamName: Optional[TeamName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse = {
    import RegisterSlackWorkspaceForOrganizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse
      .builder()
      .optionallyWith(accountType.map(value => value.unwrap))(_.accountType)
      .optionallyWith(
        teamId.map(value => TeamId.unwrap(value): java.lang.String)
      )(_.teamId)
      .optionallyWith(
        teamName.map(value => TeamName.unwrap(value): java.lang.String)
      )(_.teamName)
      .build()
  }
  def asReadOnly
      : zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse.ReadOnly =
    zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse
      .wrap(buildAwsValue())
}
object RegisterSlackWorkspaceForOrganizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse =
      zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse(
        accountType.map(value => value),
        teamId.map(value => value),
        teamName.map(value => value)
      )
    def accountType: Optional[zio.aws.supportapp.model.AccountType]
    def teamId: Optional[TeamId]
    def teamName: Optional[TeamName]
    def getAccountType
        : ZIO[Any, AwsError, zio.aws.supportapp.model.AccountType] =
      AwsError.unwrapOptionField("accountType", accountType)
    def getTeamId: ZIO[Any, AwsError, TeamId] =
      AwsError.unwrapOptionField("teamId", teamId)
    def getTeamName: ZIO[Any, AwsError, TeamName] =
      AwsError.unwrapOptionField("teamName", teamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse
  ) extends zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse.ReadOnly {
    override val accountType: Optional[zio.aws.supportapp.model.AccountType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountType())
        .map(value => zio.aws.supportapp.model.AccountType.wrap(value))
    override val teamId: Optional[TeamId] = zio.aws.core.internal
      .optionalFromNullable(impl.teamId())
      .map(value => zio.aws.supportapp.model.primitives.TeamId(value))
    override val teamName: Optional[TeamName] = zio.aws.core.internal
      .optionalFromNullable(impl.teamName())
      .map(value => zio.aws.supportapp.model.primitives.TeamName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse
  ): zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse.ReadOnly =
    new Wrapper(impl)
}
