package zio.aws.supportapp.model
import zio.ZIO
import zio.aws.supportapp.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSlackChannelConfigurationsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsRequest = {
    import ListSlackChannelConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.supportapp.model.ListSlackChannelConfigurationsRequest.ReadOnly =
    zio.aws.supportapp.model.ListSlackChannelConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListSlackChannelConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.supportapp.model.ListSlackChannelConfigurationsRequest =
      zio.aws.supportapp.model
        .ListSlackChannelConfigurationsRequest(nextToken.map(value => value))
    def nextToken: Optional[PaginationToken]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsRequest
  ) extends zio.aws.supportapp.model.ListSlackChannelConfigurationsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.supportapp.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsRequest
  ): zio.aws.supportapp.model.ListSlackChannelConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
