package zio.aws.supportapp.model
import zio.ZIO
import zio.aws.supportapp.model.primitives.TeamId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSlackWorkspaceConfigurationRequest(teamId: TeamId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.supportapp.model.DeleteSlackWorkspaceConfigurationRequest = {
    import DeleteSlackWorkspaceConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.supportapp.model.DeleteSlackWorkspaceConfigurationRequest
      .builder()
      .teamId(TeamId.unwrap(teamId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.supportapp.model.DeleteSlackWorkspaceConfigurationRequest.ReadOnly =
    zio.aws.supportapp.model.DeleteSlackWorkspaceConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteSlackWorkspaceConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.supportapp.model.DeleteSlackWorkspaceConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.supportapp.model.DeleteSlackWorkspaceConfigurationRequest =
      zio.aws.supportapp.model.DeleteSlackWorkspaceConfigurationRequest(teamId)
    def teamId: TeamId
    def getTeamId: ZIO[Any, Nothing, TeamId] = ZIO.succeed(teamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.supportapp.model.DeleteSlackWorkspaceConfigurationRequest
  ) extends zio.aws.supportapp.model.DeleteSlackWorkspaceConfigurationRequest.ReadOnly {
    override val teamId: TeamId =
      zio.aws.supportapp.model.primitives.TeamId(impl.teamId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.supportapp.model.DeleteSlackWorkspaceConfigurationRequest
  ): zio.aws.supportapp.model.DeleteSlackWorkspaceConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
