package zio.aws.supportapp.model
import zio.ZIO
import zio.aws.supportapp.model.primitives.TeamId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SlackWorkspaceConfiguration(teamId: TeamId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.supportapp.model.SlackWorkspaceConfiguration = {
    import SlackWorkspaceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.supportapp.model.SlackWorkspaceConfiguration
      .builder()
      .teamId(TeamId.unwrap(teamId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.supportapp.model.SlackWorkspaceConfiguration.ReadOnly =
    zio.aws.supportapp.model.SlackWorkspaceConfiguration.wrap(buildAwsValue())
}
object SlackWorkspaceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.supportapp.model.SlackWorkspaceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.supportapp.model.SlackWorkspaceConfiguration =
      zio.aws.supportapp.model.SlackWorkspaceConfiguration(teamId)
    def teamId: TeamId
    def getTeamId: ZIO[Any, Nothing, TeamId] = ZIO.succeed(teamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.supportapp.model.SlackWorkspaceConfiguration
  ) extends zio.aws.supportapp.model.SlackWorkspaceConfiguration.ReadOnly {
    override val teamId: TeamId =
      zio.aws.supportapp.model.primitives.TeamId(impl.teamId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.supportapp.model.SlackWorkspaceConfiguration
  ): zio.aws.supportapp.model.SlackWorkspaceConfiguration.ReadOnly =
    new Wrapper(impl)
}
