package zio.aws.supportapp.model
import zio.ZIO
import zio.aws.supportapp.model.primitives.{TeamName, TeamId, BooleanValue}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SlackWorkspaceConfiguration(
    allowOrganizationMemberAccount: Optional[BooleanValue] = Optional.Absent,
    teamId: TeamId,
    teamName: Optional[TeamName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.supportapp.model.SlackWorkspaceConfiguration = {
    import SlackWorkspaceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.supportapp.model.SlackWorkspaceConfiguration
      .builder()
      .optionallyWith(
        allowOrganizationMemberAccount.map(value => value: java.lang.Boolean)
      )(_.allowOrganizationMemberAccount)
      .teamId(TeamId.unwrap(teamId): java.lang.String)
      .optionallyWith(
        teamName.map(value => TeamName.unwrap(value): java.lang.String)
      )(_.teamName)
      .build()
  }
  def asReadOnly
      : zio.aws.supportapp.model.SlackWorkspaceConfiguration.ReadOnly =
    zio.aws.supportapp.model.SlackWorkspaceConfiguration.wrap(buildAwsValue())
}
object SlackWorkspaceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.supportapp.model.SlackWorkspaceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.supportapp.model.SlackWorkspaceConfiguration =
      zio.aws.supportapp.model.SlackWorkspaceConfiguration(
        allowOrganizationMemberAccount.map(value => value),
        teamId,
        teamName.map(value => value)
      )
    def allowOrganizationMemberAccount: Optional[BooleanValue]
    def teamId: TeamId
    def teamName: Optional[TeamName]
    def getAllowOrganizationMemberAccount: ZIO[Any, AwsError, BooleanValue] =
      AwsError.unwrapOptionField(
        "allowOrganizationMemberAccount",
        allowOrganizationMemberAccount
      )
    def getTeamId: ZIO[Any, Nothing, TeamId] = ZIO.succeed(teamId)
    def getTeamName: ZIO[Any, AwsError, TeamName] =
      AwsError.unwrapOptionField("teamName", teamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.supportapp.model.SlackWorkspaceConfiguration
  ) extends zio.aws.supportapp.model.SlackWorkspaceConfiguration.ReadOnly {
    override val allowOrganizationMemberAccount: Optional[BooleanValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowOrganizationMemberAccount())
        .map(value => value: BooleanValue)
    override val teamId: TeamId =
      zio.aws.supportapp.model.primitives.TeamId(impl.teamId())
    override val teamName: Optional[TeamName] = zio.aws.core.internal
      .optionalFromNullable(impl.teamName())
      .map(value => zio.aws.supportapp.model.primitives.TeamName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.supportapp.model.SlackWorkspaceConfiguration
  ): zio.aws.supportapp.model.SlackWorkspaceConfiguration.ReadOnly =
    new Wrapper(impl)
}
