package zio.aws.supportapp.model
import zio.ZIO
import zio.aws.supportapp.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSlackWorkspaceConfigurationsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest = {
    import ListSlackWorkspaceConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsRequest.ReadOnly =
    zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListSlackWorkspaceConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsRequest =
      zio.aws.supportapp.model
        .ListSlackWorkspaceConfigurationsRequest(nextToken.map(value => value))
    def nextToken: Optional[PaginationToken]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest
  ) extends zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.supportapp.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest
  ): zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
