package zio.aws.supportapp.model
import zio.ZIO
import zio.aws.supportapp.model.primitives.AwsAccountAlias
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutAccountAliasRequest(accountAlias: AwsAccountAlias) {
  def buildAwsValue()
      : software.amazon.awssdk.services.supportapp.model.PutAccountAliasRequest = {
    import PutAccountAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.supportapp.model.PutAccountAliasRequest
      .builder()
      .accountAlias(AwsAccountAlias.unwrap(accountAlias): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.supportapp.model.PutAccountAliasRequest.ReadOnly =
    zio.aws.supportapp.model.PutAccountAliasRequest.wrap(buildAwsValue())
}
object PutAccountAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.supportapp.model.PutAccountAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.supportapp.model.PutAccountAliasRequest =
      zio.aws.supportapp.model.PutAccountAliasRequest(accountAlias)
    def accountAlias: AwsAccountAlias
    def getAccountAlias: ZIO[Any, Nothing, AwsAccountAlias] =
      ZIO.succeed(accountAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.supportapp.model.PutAccountAliasRequest
  ) extends zio.aws.supportapp.model.PutAccountAliasRequest.ReadOnly {
    override val accountAlias: AwsAccountAlias =
      zio.aws.supportapp.model.primitives.AwsAccountAlias(impl.accountAlias())
  }
  def wrap(
      impl: software.amazon.awssdk.services.supportapp.model.PutAccountAliasRequest
  ): zio.aws.supportapp.model.PutAccountAliasRequest.ReadOnly = new Wrapper(
    impl
  )
}
