package zio.aws.supportapp.model
import zio.ZIO
import zio.aws.supportapp.model.primitives.{
  RoleArn,
  TeamId,
  ChannelName,
  ChannelId,
  BooleanValue
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSlackChannelConfigurationRequest(
    channelId: ChannelId,
    channelName: Optional[ChannelName] = Optional.Absent,
    channelRoleArn: Optional[RoleArn] = Optional.Absent,
    notifyOnAddCorrespondenceToCase: Optional[BooleanValue] = Optional.Absent,
    notifyOnCaseSeverity: Optional[
      zio.aws.supportapp.model.NotificationSeverityLevel
    ] = Optional.Absent,
    notifyOnCreateOrReopenCase: Optional[BooleanValue] = Optional.Absent,
    notifyOnResolveCase: Optional[BooleanValue] = Optional.Absent,
    teamId: TeamId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.supportapp.model.UpdateSlackChannelConfigurationRequest = {
    import UpdateSlackChannelConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.supportapp.model.UpdateSlackChannelConfigurationRequest
      .builder()
      .channelId(ChannelId.unwrap(channelId): java.lang.String)
      .optionallyWith(
        channelName.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.channelName)
      .optionallyWith(
        channelRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.channelRoleArn)
      .optionallyWith(
        notifyOnAddCorrespondenceToCase.map(value => value: java.lang.Boolean)
      )(_.notifyOnAddCorrespondenceToCase)
      .optionallyWith(notifyOnCaseSeverity.map(value => value.unwrap))(
        _.notifyOnCaseSeverity
      )
      .optionallyWith(
        notifyOnCreateOrReopenCase.map(value => value: java.lang.Boolean)
      )(_.notifyOnCreateOrReopenCase)
      .optionallyWith(
        notifyOnResolveCase.map(value => value: java.lang.Boolean)
      )(_.notifyOnResolveCase)
      .teamId(TeamId.unwrap(teamId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.supportapp.model.UpdateSlackChannelConfigurationRequest.ReadOnly =
    zio.aws.supportapp.model.UpdateSlackChannelConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateSlackChannelConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.supportapp.model.UpdateSlackChannelConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.supportapp.model.UpdateSlackChannelConfigurationRequest =
      zio.aws.supportapp.model.UpdateSlackChannelConfigurationRequest(
        channelId,
        channelName.map(value => value),
        channelRoleArn.map(value => value),
        notifyOnAddCorrespondenceToCase.map(value => value),
        notifyOnCaseSeverity.map(value => value),
        notifyOnCreateOrReopenCase.map(value => value),
        notifyOnResolveCase.map(value => value),
        teamId
      )
    def channelId: ChannelId
    def channelName: Optional[ChannelName]
    def channelRoleArn: Optional[RoleArn]
    def notifyOnAddCorrespondenceToCase: Optional[BooleanValue]
    def notifyOnCaseSeverity
        : Optional[zio.aws.supportapp.model.NotificationSeverityLevel]
    def notifyOnCreateOrReopenCase: Optional[BooleanValue]
    def notifyOnResolveCase: Optional[BooleanValue]
    def teamId: TeamId
    def getChannelId: ZIO[Any, Nothing, ChannelId] = ZIO.succeed(channelId)
    def getChannelName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("channelName", channelName)
    def getChannelRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("channelRoleArn", channelRoleArn)
    def getNotifyOnAddCorrespondenceToCase: ZIO[Any, AwsError, BooleanValue] =
      AwsError.unwrapOptionField(
        "notifyOnAddCorrespondenceToCase",
        notifyOnAddCorrespondenceToCase
      )
    def getNotifyOnCaseSeverity: ZIO[
      Any,
      AwsError,
      zio.aws.supportapp.model.NotificationSeverityLevel
    ] = AwsError.unwrapOptionField("notifyOnCaseSeverity", notifyOnCaseSeverity)
    def getNotifyOnCreateOrReopenCase: ZIO[Any, AwsError, BooleanValue] =
      AwsError.unwrapOptionField(
        "notifyOnCreateOrReopenCase",
        notifyOnCreateOrReopenCase
      )
    def getNotifyOnResolveCase: ZIO[Any, AwsError, BooleanValue] =
      AwsError.unwrapOptionField("notifyOnResolveCase", notifyOnResolveCase)
    def getTeamId: ZIO[Any, Nothing, TeamId] = ZIO.succeed(teamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.supportapp.model.UpdateSlackChannelConfigurationRequest
  ) extends zio.aws.supportapp.model.UpdateSlackChannelConfigurationRequest.ReadOnly {
    override val channelId: ChannelId =
      zio.aws.supportapp.model.primitives.ChannelId(impl.channelId())
    override val channelName: Optional[ChannelName] = zio.aws.core.internal
      .optionalFromNullable(impl.channelName())
      .map(value => zio.aws.supportapp.model.primitives.ChannelName(value))
    override val channelRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelRoleArn())
      .map(value => zio.aws.supportapp.model.primitives.RoleArn(value))
    override val notifyOnAddCorrespondenceToCase: Optional[BooleanValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifyOnAddCorrespondenceToCase())
        .map(value => value: BooleanValue)
    override val notifyOnCaseSeverity
        : Optional[zio.aws.supportapp.model.NotificationSeverityLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifyOnCaseSeverity())
        .map(value =>
          zio.aws.supportapp.model.NotificationSeverityLevel.wrap(value)
        )
    override val notifyOnCreateOrReopenCase: Optional[BooleanValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifyOnCreateOrReopenCase())
        .map(value => value: BooleanValue)
    override val notifyOnResolveCase: Optional[BooleanValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifyOnResolveCase())
        .map(value => value: BooleanValue)
    override val teamId: TeamId =
      zio.aws.supportapp.model.primitives.TeamId(impl.teamId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.supportapp.model.UpdateSlackChannelConfigurationRequest
  ): zio.aws.supportapp.model.UpdateSlackChannelConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
