package zio.aws.supportapp.model
import zio.ZIO
import zio.aws.supportapp.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSlackChannelConfigurationsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    slackChannelConfigurations: Iterable[
      zio.aws.supportapp.model.SlackChannelConfiguration
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsResponse = {
    import ListSlackChannelConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .slackChannelConfigurations(slackChannelConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.supportapp.model.ListSlackChannelConfigurationsResponse.ReadOnly =
    zio.aws.supportapp.model.ListSlackChannelConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListSlackChannelConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.supportapp.model.ListSlackChannelConfigurationsResponse =
      zio.aws.supportapp.model.ListSlackChannelConfigurationsResponse(
        nextToken.map(value => value),
        slackChannelConfigurations.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[PaginationToken]
    def slackChannelConfigurations
        : List[zio.aws.supportapp.model.SlackChannelConfiguration.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSlackChannelConfigurations: ZIO[Any, Nothing, List[
      zio.aws.supportapp.model.SlackChannelConfiguration.ReadOnly
    ]] = ZIO.succeed(slackChannelConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsResponse
  ) extends zio.aws.supportapp.model.ListSlackChannelConfigurationsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.supportapp.model.primitives.PaginationToken(value))
    override val slackChannelConfigurations
        : List[zio.aws.supportapp.model.SlackChannelConfiguration.ReadOnly] =
      impl
        .slackChannelConfigurations()
        .asScala
        .map { item =>
          zio.aws.supportapp.model.SlackChannelConfiguration.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsResponse
  ): zio.aws.supportapp.model.ListSlackChannelConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
