package zio.aws.supportapp.model
import zio.ZIO
import zio.aws.supportapp.model.primitives.{TeamId, ChannelId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteSlackChannelConfigurationRequest(
    channelId: ChannelId,
    teamId: TeamId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.supportapp.model.DeleteSlackChannelConfigurationRequest = {
    import DeleteSlackChannelConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.supportapp.model.DeleteSlackChannelConfigurationRequest
      .builder()
      .channelId(ChannelId.unwrap(channelId): java.lang.String)
      .teamId(TeamId.unwrap(teamId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.supportapp.model.DeleteSlackChannelConfigurationRequest.ReadOnly =
    zio.aws.supportapp.model.DeleteSlackChannelConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteSlackChannelConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.supportapp.model.DeleteSlackChannelConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.supportapp.model.DeleteSlackChannelConfigurationRequest =
      zio.aws.supportapp.model
        .DeleteSlackChannelConfigurationRequest(channelId, teamId)
    def channelId: ChannelId
    def teamId: TeamId
    def getChannelId: ZIO[Any, Nothing, ChannelId] = ZIO.succeed(channelId)
    def getTeamId: ZIO[Any, Nothing, TeamId] = ZIO.succeed(teamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.supportapp.model.DeleteSlackChannelConfigurationRequest
  ) extends zio.aws.supportapp.model.DeleteSlackChannelConfigurationRequest.ReadOnly {
    override val channelId: ChannelId =
      zio.aws.supportapp.model.primitives.ChannelId(impl.channelId())
    override val teamId: TeamId =
      zio.aws.supportapp.model.primitives.TeamId(impl.teamId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.supportapp.model.DeleteSlackChannelConfigurationRequest
  ): zio.aws.supportapp.model.DeleteSlackChannelConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
