package zio.aws.supportapp.model
import scala.jdk.CollectionConverters._
sealed trait NotificationSeverityLevel {
  def unwrap: software.amazon.awssdk.services.supportapp.model.NotificationSeverityLevel
}
object NotificationSeverityLevel {
  def wrap(
      value: software.amazon.awssdk.services.supportapp.model.NotificationSeverityLevel
  ): zio.aws.supportapp.model.NotificationSeverityLevel = value match {
    case software.amazon.awssdk.services.supportapp.model.NotificationSeverityLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.supportapp.model.NotificationSeverityLevel.NONE =>
      val r = none
      r
    case software.amazon.awssdk.services.supportapp.model.NotificationSeverityLevel.ALL =>
      val r = all
      r
    case software.amazon.awssdk.services.supportapp.model.NotificationSeverityLevel.HIGH =>
      val r = high
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.supportapp.model.NotificationSeverityLevel {
    override def unwrap
        : software.amazon.awssdk.services.supportapp.model.NotificationSeverityLevel =
      software.amazon.awssdk.services.supportapp.model.NotificationSeverityLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object none extends zio.aws.supportapp.model.NotificationSeverityLevel {
    override def unwrap
        : software.amazon.awssdk.services.supportapp.model.NotificationSeverityLevel =
      software.amazon.awssdk.services.supportapp.model.NotificationSeverityLevel.NONE
  }
  case object all extends zio.aws.supportapp.model.NotificationSeverityLevel {
    override def unwrap
        : software.amazon.awssdk.services.supportapp.model.NotificationSeverityLevel =
      software.amazon.awssdk.services.supportapp.model.NotificationSeverityLevel.ALL
  }
  case object high extends zio.aws.supportapp.model.NotificationSeverityLevel {
    override def unwrap
        : software.amazon.awssdk.services.supportapp.model.NotificationSeverityLevel =
      software.amazon.awssdk.services.supportapp.model.NotificationSeverityLevel.HIGH
  }
}
