package zio.aws.supportapp.model
import scala.jdk.CollectionConverters._
sealed trait AccountType {
  def unwrap: software.amazon.awssdk.services.supportapp.model.AccountType
}
object AccountType {
  def wrap(
      value: software.amazon.awssdk.services.supportapp.model.AccountType
  ): zio.aws.supportapp.model.AccountType = value match {
    case software.amazon.awssdk.services.supportapp.model.AccountType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.supportapp.model.AccountType.MANAGEMENT =>
      val r = management
      r
    case software.amazon.awssdk.services.supportapp.model.AccountType.MEMBER =>
      val r = member
      r
  }
  case object unknownToSdkVersion extends zio.aws.supportapp.model.AccountType {
    override def unwrap
        : software.amazon.awssdk.services.supportapp.model.AccountType =
      software.amazon.awssdk.services.supportapp.model.AccountType.UNKNOWN_TO_SDK_VERSION
  }
  case object management extends zio.aws.supportapp.model.AccountType {
    override def unwrap
        : software.amazon.awssdk.services.supportapp.model.AccountType =
      software.amazon.awssdk.services.supportapp.model.AccountType.MANAGEMENT
  }
  case object member extends zio.aws.supportapp.model.AccountType {
    override def unwrap
        : software.amazon.awssdk.services.supportapp.model.AccountType =
      software.amazon.awssdk.services.supportapp.model.AccountType.MEMBER
  }
}
