package zio.aws.supportapp.model
import zio.ZIO
import zio.aws.supportapp.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSlackWorkspaceConfigurationsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    slackWorkspaceConfigurations: Optional[
      Iterable[zio.aws.supportapp.model.SlackWorkspaceConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsResponse = {
    import ListSlackWorkspaceConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        slackWorkspaceConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.slackWorkspaceConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsResponse.ReadOnly =
    zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListSlackWorkspaceConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsResponse =
      zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsResponse(
        nextToken.map(value => value),
        slackWorkspaceConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def slackWorkspaceConfigurations: Optional[
      List[zio.aws.supportapp.model.SlackWorkspaceConfiguration.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSlackWorkspaceConfigurations: ZIO[Any, AwsError, List[
      zio.aws.supportapp.model.SlackWorkspaceConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "slackWorkspaceConfigurations",
      slackWorkspaceConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsResponse
  ) extends zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.supportapp.model.primitives.PaginationToken(value))
    override val slackWorkspaceConfigurations: Optional[
      List[zio.aws.supportapp.model.SlackWorkspaceConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.slackWorkspaceConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.supportapp.model.SlackWorkspaceConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsResponse
  ): zio.aws.supportapp.model.ListSlackWorkspaceConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
