package zio.aws.supportapp.model
import zio.ZIO
import zio.aws.supportapp.model.primitives.TeamId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RegisterSlackWorkspaceForOrganizationRequest(teamId: TeamId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest = {
    import RegisterSlackWorkspaceForOrganizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest
      .builder()
      .teamId(TeamId.unwrap(teamId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest.ReadOnly =
    zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest
      .wrap(buildAwsValue())
}
object RegisterSlackWorkspaceForOrganizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest =
      zio.aws.supportapp.model
        .RegisterSlackWorkspaceForOrganizationRequest(teamId)
    def teamId: TeamId
    def getTeamId: ZIO[Any, Nothing, TeamId] = ZIO.succeed(teamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest
  ) extends zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest.ReadOnly {
    override val teamId: TeamId =
      zio.aws.supportapp.model.primitives.TeamId(impl.teamId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest
  ): zio.aws.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest.ReadOnly =
    new Wrapper(impl)
}
