package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateGatewaySoftwareNowResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateGatewaySoftwareNowResponse = {
    import UpdateGatewaySoftwareNowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateGatewaySoftwareNowResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateGatewaySoftwareNowResponse.ReadOnly =
    zio.aws.storagegateway.model.UpdateGatewaySoftwareNowResponse
      .wrap(buildAwsValue())
}
object UpdateGatewaySoftwareNowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateGatewaySoftwareNowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.UpdateGatewaySoftwareNowResponse =
      zio.aws.storagegateway.model
        .UpdateGatewaySoftwareNowResponse(gatewayARN.map(value => value))
    def gatewayARN: Optional[GatewayARN]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateGatewaySoftwareNowResponse
  ) extends zio.aws.storagegateway.model.UpdateGatewaySoftwareNowResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateGatewaySoftwareNowResponse
  ): zio.aws.storagegateway.model.UpdateGatewaySoftwareNowResponse.ReadOnly =
    new Wrapper(impl)
}
