package zio.aws.storagegateway.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{
  PositiveIntObject,
  Marker,
  TapeARN
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTapesRequest(
    tapeARNs: Optional[Iterable[TapeARN]] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent,
    limit: Optional[PositiveIntObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListTapesRequest = {
    import ListTapesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListTapesRequest
      .builder()
      .optionallyWith(
        tapeARNs.map(value =>
          value.map { item =>
            TapeARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tapeARNs)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        limit.map(value => PositiveIntObject.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ListTapesRequest.ReadOnly =
    zio.aws.storagegateway.model.ListTapesRequest.wrap(buildAwsValue())
}
object ListTapesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListTapesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ListTapesRequest =
      zio.aws.storagegateway.model.ListTapesRequest(
        tapeARNs.map(value => value),
        marker.map(value => value),
        limit.map(value => value)
      )
    def tapeARNs: Optional[List[TapeARN]]
    def marker: Optional[Marker]
    def limit: Optional[PositiveIntObject]
    def getTapeARNs: ZIO[Any, AwsError, List[TapeARN]] =
      AwsError.unwrapOptionField("tapeARNs", tapeARNs)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, PositiveIntObject] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListTapesRequest
  ) extends zio.aws.storagegateway.model.ListTapesRequest.ReadOnly {
    override val tapeARNs: Optional[List[TapeARN]] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeARNs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.TapeARN(item)
        }.toList
      )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val limit: Optional[PositiveIntObject] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.storagegateway.model.primitives.PositiveIntObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListTapesRequest
  ): zio.aws.storagegateway.model.ListTapesRequest.ReadOnly = new Wrapper(impl)
}
