package zio.aws.storagegateway.model
import scala.jdk.CollectionConverters.*
sealed trait HostEnvironment {
  def unwrap
      : software.amazon.awssdk.services.storagegateway.model.HostEnvironment
}
object HostEnvironment {
  def wrap(
      value: software.amazon.awssdk.services.storagegateway.model.HostEnvironment
  ): zio.aws.storagegateway.model.HostEnvironment = value match {
    case software.amazon.awssdk.services.storagegateway.model.HostEnvironment.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.storagegateway.model.HostEnvironment.VMWARE =>
      val r = VMWARE
      r
    case software.amazon.awssdk.services.storagegateway.model.HostEnvironment.HYPER_V =>
      val r = `HYPER-V`
      r
    case software.amazon.awssdk.services.storagegateway.model.HostEnvironment.EC2 =>
      val r = EC2
      r
    case software.amazon.awssdk.services.storagegateway.model.HostEnvironment.KVM =>
      val r = KVM
      r
    case software.amazon.awssdk.services.storagegateway.model.HostEnvironment.OTHER =>
      val r = OTHER
      r
    case software.amazon.awssdk.services.storagegateway.model.HostEnvironment.SNOWBALL =>
      val r = SNOWBALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.storagegateway.model.HostEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.HostEnvironment =
      software.amazon.awssdk.services.storagegateway.model.HostEnvironment.UNKNOWN_TO_SDK_VERSION
  }
  case object VMWARE extends zio.aws.storagegateway.model.HostEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.HostEnvironment =
      software.amazon.awssdk.services.storagegateway.model.HostEnvironment.VMWARE
  }
  case object `HYPER-V` extends zio.aws.storagegateway.model.HostEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.HostEnvironment =
      software.amazon.awssdk.services.storagegateway.model.HostEnvironment.HYPER_V
  }
  case object EC2 extends zio.aws.storagegateway.model.HostEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.HostEnvironment =
      software.amazon.awssdk.services.storagegateway.model.HostEnvironment.EC2
  }
  case object KVM extends zio.aws.storagegateway.model.HostEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.HostEnvironment =
      software.amazon.awssdk.services.storagegateway.model.HostEnvironment.KVM
  }
  case object OTHER extends zio.aws.storagegateway.model.HostEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.HostEnvironment =
      software.amazon.awssdk.services.storagegateway.model.HostEnvironment.OTHER
  }
  case object SNOWBALL extends zio.aws.storagegateway.model.HostEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.HostEnvironment =
      software.amazon.awssdk.services.storagegateway.model.HostEnvironment.SNOWBALL
  }
}
