package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.VolumeARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteSnapshotScheduleResponse(
    volumeARN: Optional[VolumeARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DeleteSnapshotScheduleResponse = {
    import DeleteSnapshotScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DeleteSnapshotScheduleResponse
      .builder()
      .optionallyWith(
        volumeARN.map(value => VolumeARN.unwrap(value): java.lang.String)
      )(_.volumeARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DeleteSnapshotScheduleResponse.ReadOnly =
    zio.aws.storagegateway.model.DeleteSnapshotScheduleResponse
      .wrap(buildAwsValue())
}
object DeleteSnapshotScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DeleteSnapshotScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DeleteSnapshotScheduleResponse =
      zio.aws.storagegateway.model
        .DeleteSnapshotScheduleResponse(volumeARN.map(value => value))
    def volumeARN: Optional[VolumeARN]
    def getVolumeARN: ZIO[Any, AwsError, VolumeARN] =
      AwsError.unwrapOptionField("volumeARN", volumeARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteSnapshotScheduleResponse
  ) extends zio.aws.storagegateway.model.DeleteSnapshotScheduleResponse.ReadOnly {
    override val volumeARN: Optional[VolumeARN] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeARN())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteSnapshotScheduleResponse
  ): zio.aws.storagegateway.model.DeleteSnapshotScheduleResponse.ReadOnly =
    new Wrapper(impl)
}
