package zio.aws.storagegateway.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{
  RetentionLockTimeInDays,
  PoolName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateTapePoolRequest(
    poolName: PoolName,
    storageClass: zio.aws.storagegateway.model.TapeStorageClass,
    retentionLockType: Optional[
      zio.aws.storagegateway.model.RetentionLockType
    ] = Optional.Absent,
    retentionLockTimeInDays: Optional[RetentionLockTimeInDays] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.storagegateway.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CreateTapePoolRequest = {
    import CreateTapePoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CreateTapePoolRequest
      .builder()
      .poolName(PoolName.unwrap(poolName): java.lang.String)
      .storageClass(storageClass.unwrap)
      .optionallyWith(retentionLockType.map(value => value.unwrap))(
        _.retentionLockType
      )
      .optionallyWith(
        retentionLockTimeInDays.map(value =>
          RetentionLockTimeInDays.unwrap(value): Integer
        )
      )(_.retentionLockTimeInDays)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.CreateTapePoolRequest.ReadOnly =
    zio.aws.storagegateway.model.CreateTapePoolRequest.wrap(buildAwsValue())
}
object CreateTapePoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CreateTapePoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.CreateTapePoolRequest =
      zio.aws.storagegateway.model.CreateTapePoolRequest(
        poolName,
        storageClass,
        retentionLockType.map(value => value),
        retentionLockTimeInDays.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def poolName: PoolName
    def storageClass: zio.aws.storagegateway.model.TapeStorageClass
    def retentionLockType
        : Optional[zio.aws.storagegateway.model.RetentionLockType]
    def retentionLockTimeInDays: Optional[RetentionLockTimeInDays]
    def tags: Optional[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def getPoolName: ZIO[Any, Nothing, PoolName] = ZIO.succeed(poolName)
    def getStorageClass
        : ZIO[Any, Nothing, zio.aws.storagegateway.model.TapeStorageClass] =
      ZIO.succeed(storageClass)
    def getRetentionLockType
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.RetentionLockType] =
      AwsError.unwrapOptionField("retentionLockType", retentionLockType)
    def getRetentionLockTimeInDays
        : ZIO[Any, AwsError, RetentionLockTimeInDays] = AwsError
      .unwrapOptionField("retentionLockTimeInDays", retentionLockTimeInDays)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateTapePoolRequest
  ) extends zio.aws.storagegateway.model.CreateTapePoolRequest.ReadOnly {
    override val poolName: PoolName =
      zio.aws.storagegateway.model.primitives.PoolName(impl.poolName())
    override val storageClass: zio.aws.storagegateway.model.TapeStorageClass =
      zio.aws.storagegateway.model.TapeStorageClass.wrap(impl.storageClass())
    override val retentionLockType
        : Optional[zio.aws.storagegateway.model.RetentionLockType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionLockType())
        .map(value =>
          zio.aws.storagegateway.model.RetentionLockType.wrap(value)
        )
    override val retentionLockTimeInDays: Optional[RetentionLockTimeInDays] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionLockTimeInDays())
        .map(value =>
          zio.aws.storagegateway.model.primitives.RetentionLockTimeInDays(value)
        )
    override val tags
        : Optional[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateTapePoolRequest
  ): zio.aws.storagegateway.model.CreateTapePoolRequest.ReadOnly = new Wrapper(
    impl
  )
}
