package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateBandwidthRateLimitScheduleResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse = {
    import UpdateBandwidthRateLimitScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse.ReadOnly =
    zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse
      .wrap(buildAwsValue())
}
object UpdateBandwidthRateLimitScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse =
      zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse(
        gatewayARN.map(value => value)
      )
    def gatewayARN: Optional[GatewayARN]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse
  ) extends zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse
  ): zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse.ReadOnly =
    new Wrapper(impl)
}
