package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.FileShareARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSmbFileShareResponse(
    fileShareARN: Optional[FileShareARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CreateSmbFileShareResponse = {
    import CreateSmbFileShareResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CreateSmbFileShareResponse
      .builder()
      .optionallyWith(
        fileShareARN.map(value => FileShareARN.unwrap(value): java.lang.String)
      )(_.fileShareARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.CreateSmbFileShareResponse.ReadOnly =
    zio.aws.storagegateway.model.CreateSmbFileShareResponse
      .wrap(buildAwsValue())
}
object CreateSmbFileShareResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CreateSmbFileShareResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.CreateSmbFileShareResponse =
      zio.aws.storagegateway.model
        .CreateSmbFileShareResponse(fileShareARN.map(value => value))
    def fileShareARN: Optional[FileShareARN]
    def getFileShareARN: ZIO[Any, AwsError, FileShareARN] =
      AwsError.unwrapOptionField("fileShareARN", fileShareARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateSmbFileShareResponse
  ) extends zio.aws.storagegateway.model.CreateSmbFileShareResponse.ReadOnly {
    override val fileShareARN: Optional[FileShareARN] = zio.aws.core.internal
      .optionalFromNullable(impl.fileShareARN())
      .map(value => zio.aws.storagegateway.model.primitives.FileShareARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateSmbFileShareResponse
  ): zio.aws.storagegateway.model.CreateSmbFileShareResponse.ReadOnly =
    new Wrapper(impl)
}
