package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{Marker, GatewayARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeVtlDevicesResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    vtlDevices: Optional[Iterable[zio.aws.storagegateway.model.VTLDevice]] =
      Optional.Absent,
    marker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse = {
    import DescribeVtlDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        vtlDevices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vtlDevices)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeVtlDevicesResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeVtlDevicesResponse
      .wrap(buildAwsValue())
}
object DescribeVtlDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DescribeVtlDevicesResponse =
      zio.aws.storagegateway.model.DescribeVtlDevicesResponse(
        gatewayARN.map(value => value),
        vtlDevices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def gatewayARN: Optional[GatewayARN]
    def vtlDevices
        : Optional[List[zio.aws.storagegateway.model.VTLDevice.ReadOnly]]
    def marker: Optional[Marker]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getVtlDevices: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.VTLDevice.ReadOnly
    ]] = AwsError.unwrapOptionField("vtlDevices", vtlDevices)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse
  ) extends zio.aws.storagegateway.model.DescribeVtlDevicesResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val vtlDevices
        : Optional[List[zio.aws.storagegateway.model.VTLDevice.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vtlDevices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.VTLDevice.wrap(item)
          }.toList
        )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse
  ): zio.aws.storagegateway.model.DescribeVtlDevicesResponse.ReadOnly =
    new Wrapper(impl)
}
